//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryContext.hpp,v 1.29 2003/12/08 01:37:23 gmf Exp $
//

#ifndef __QUERYCONTEXT_HPP
#define	__QUERYCONTEXT_HPP

#include <string>
#include <map>
#include "NamespaceMap.hpp"
#include "VariableBindings.hpp"
#include "dbxml/XmlQueryContext.hpp"
#include "ReferenceCounted.hpp"

#if defined(DBXML_DOM_XERCES2)
#include <xercesc/parsers/XercesDOMParser.hpp>
#endif

class XPathSelectionTreeParser;
class XPathNSResolver;
class XPathEvaluator;
class DbTxn;

namespace DbXml
{

class XmlValue;
class OperationContext;

class QueryContext : public ReferenceCounted
{
public:
	/// Constructor.
	QueryContext(XmlQueryContext::ReturnType rt, XmlQueryContext::EvaluationType et);
	virtual ~QueryContext();

	void setNamespace( const std::string &prefix, const std::string &uri );
	std::string getNamespace( const std::string &prefix );
	void removeNamespace( const std::string &prefix );
	void clearNamespaces();
	void setVariableValue(const std::string &name, const XmlValue &value);
	bool getVariableValue(const std::string &name, XmlValue &value) const;
	void setWithMetaData(bool withMetaData) 
	{
		withMetadata_ = withMetaData;
	}
	bool getWithMetaData(void) const
	{
		return withMetadata_;
	}
	void setReturnType(XmlQueryContext::ReturnType rt = XmlQueryContext::ResultDocuments)
	{
		returnType_ = rt;
	}
	XmlQueryContext::ReturnType getReturnType() const
	{
		return returnType_;
	}
	void setEvaluationType(XmlQueryContext::EvaluationType et = XmlQueryContext::Eager)
	{
		evaluationType_ = et;
	}
	XmlQueryContext::EvaluationType getEvaluationType() const
	{
		return evaluationType_;
	}
	bool isFunction(const std::string &name) const;

	// Private stuff.

	XPathSelectionTreeParser &getXPathSelectionTreeParser()
	{
		return *xpathSelectionTreeParser_;
	}
	void setupXPathQueryContext(XPathEvaluator &evaluator, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *nsDocument, XPathNSResolver **docNSResolver);
	XERCES_CPP_NAMESPACE_QUALIFIER XercesDOMParser &getDOMParser();
	XPathEvaluator &getXPathEvaluator();
	OperationContext &getOperationContext();
	void setTransaction(DbTxn *txn);
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument &getTemporaryDocument();

private:
	// no need for copy and assignment
	QueryContext(const QueryContext&);
	QueryContext &operator=(const QueryContext &);

	std::string returnVariable_;
	bool withMetadata_;
	NamespaceMap namespaces_;
	VariableBindings variables_;
	XmlQueryContext::ReturnType returnType_;
	XmlQueryContext::EvaluationType evaluationType_;

	XPathSelectionTreeParser *xpathSelectionTreeParser_;
	XERCES_CPP_NAMESPACE_QUALIFIER XercesDOMParser *domParser_;
	XPathEvaluator *xpathEvaluator_;
	OperationContext *operationContext_;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *tmpDocument_;
};

}

#endif

