//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

#ifndef __OPERATIONCONTEXT_HPP
#define	__OPERATIONCONTEXT_HPP

#include "ScopedDbt.hpp"

namespace DbXml
{

class OperationContext
{
public:
	OperationContext(DbTxn *t = 0) : txn_(t)
	{ }

	DbTxn *txn()
	{
		return txn_;
	}
	DbtOut &key()
	{
		return key_;
	}
	DbtOut &data()
	{
		return data_;
	}

	void set(DbTxn *t)
	{
		txn_ = t;
	}

private:
	// no need for copy and assignment
	OperationContext(const OperationContext&);
	OperationContext &operator=(const OperationContext &);

	DbtOut key_;
	DbtOut data_;
	DbTxn *txn_;

};

}

#endif
