//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Name.hpp,v 1.10 2003/05/09 00:01:49 mjc Exp $
//

#ifndef __NAME_HPP
#define	__NAME_HPP

#include <string>

namespace DbXml
{
class DbtOut;
class Name
{
public:
	static const Name dbxml_colon_id;
	static const Name dbxml_colon_name;
	static const Name dbxml_colon_content;

	Name();
	Name(const char *uri, const char *prefix, const char *name);
	Name(const std::string &uri, const std::string &prefix, const std::string &name);
	Name(const char *uriname);
	Name(const Name &n);
	~Name();
	Name &operator = (const Name &n);
	bool operator<(const Name &n) const;
	bool operator==(const Name &n) const;
	const char *getURI() const;
	const char *getPrefix() const;
	const char *getName() const;
	const std::string getURIName() const;
	const std::string getPrefixName() const;
	void setThisFromDbt(const DbtOut &dbt, bool swap);
	void setDbtFromThis_PrimaryValue(DbtOut &dbt, bool swap) const;
	void setDbtFromThis_SecondaryKey(DbtOut &dbt, bool swap) const;
	void reset();
	bool hasPrefix() const;
	bool hasURI() const;
	std::string asString() const;
private:
	int compare(const Name &n) const;
	std::string &uri();
	std::string &prefix();
	void set(const Name &n);
	void set(const char *u, size_t ul, const char *p, size_t pl, const char *n, size_t nl);

	const Name *known_;
	size_t size_;
	char *buffer_;
	char *uri_;
	char *prefix_;
	char *name_;
};

std::ostream& operator<<(std::ostream& s, const Name &name);

}

#endif
