//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Modify.hpp,v 1.4 2003/12/04 21:57:04 merrells Exp $
//

#ifndef __MODIFY_HPP
#define __MODIFY_HPP

#include <string>
#include "ReferenceCounted.hpp"
#include "dbxml/XmlModify.hpp"

namespace DbXml
{

class Modify : public ReferenceCounted
{
public:
	Modify(XmlQueryExpression *expression, const std::string *xpath, XmlModify::ModificationType operation,
	       XmlModify::XmlObject type, const std::string *name, const std::string *content, int location,
	       XmlQueryContext *context);
	virtual ~Modify();

	void setNewEncoding(const std::string *newEncoding);

	XmlQueryExpression *getExpression() const { return expr_; }
	XmlQueryContext *getContext() const { return context_; }
	XmlModify::ModificationType getOperation() const { return op_; }
	XmlModify::XmlObject getType() const { return type_; }
	int getLocation() const { return location_; }
	int getNumOps() const { return numOps_; }
	void clearOps() const { numOps_ = 0; }
	void incrOps() const { numOps_ += 1; }
	const std::string *getXPath() const;
	const std::string *getName() const;
	const std::string *getContent() const;
	const std::string *getNewEncoding() const;
private:
	XmlQueryExpression *expr_;
	XmlQueryContext *context_;
	XmlModify::ModificationType op_;
	XmlModify::XmlObject type_;
	// these must be objects, not pointers or references, in order to
	// work with by-value-only languages (scripting, Java...)
	std::string xpath_;
	std::string name_;
	std::string content_;
	std::string newEncoding_;
	int location_;
	mutable int numOps_;
};


}
#endif
