//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: Modify.cpp,v 1.4 2003/12/04 21:57:03 merrells Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlException.hpp"
#include "dbxml/XmlQueryExpression.hpp"
#include "QueryExpression.hpp"
#include "QueryContext.hpp"
#include "Modify.hpp"

using namespace DbXml;

Modify::Modify(XmlQueryExpression *expression, const std::string *xpath, XmlModify::ModificationType operation,
	       XmlModify::XmlObject type, const std::string *name, const std::string *content, int location,
	       XmlQueryContext *context)
	: expr_(expression), context_(context), op_(operation), type_(type), location_(location), numOps_(0)
{
	if (xpath) {
		xpath_ = *xpath;
	} else {
		if (!expression)
			throw XmlException(XmlException::INVALID_VALUE,
					   "XmlModify must have either XmlQueryExpression or XPath");
		QueryExpression &qe = (QueryExpression&)(*expr_);
		xpath_ = qe.getXPathQuery();
		// QE must be constructed with QueryContext
		// with return type of ResultDocumentsAndValues
		if (qe.getContext().getReturnType() != XmlQueryContext::ResultDocumentsAndValues)
			throw XmlException(XmlException::INVALID_VALUE,
					   "XmlQueryExpression used in XmlModify construction must be created using XmlQueryContext with a ReturnType of XmlQueryContext::ResultDocumentsAndValues");
	}
	if (!context && expression)
		context_ = &expr_->getQueryContext();
	if (name)
		name_ = *name;
	if (content)
		content_ = *content;
}
			     
Modify::~Modify()
{
}

void Modify::setNewEncoding(const std::string *newEncoding)
{
	newEncoding_ = *newEncoding;
}

const std::string *Modify::getXPath() const {
	if (xpath_.length())
		return &xpath_;
	else
		return NULL;
}
const std::string *Modify::getName() const {
	if (name_.length())
		return &name_;
	else
		return NULL;
}
const std::string *Modify::getContent() const {
	if (content_.length())
		return &content_;
	else
		return NULL;
}
const std::string *Modify::getNewEncoding() const {
	if (newEncoding_.length())
		return &newEncoding_;
	else
		return NULL;
}
