//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Log.hpp,v 1.10 2003/05/09 00:01:49 mjc Exp $
//

#ifndef __LOG_HPP
#define	__LOG_HPP

class DbEnv;

namespace DbXml
{

enum ImplLogLevel
{
    L_NONE = 0x00000000,  ///< No debug LLs are enabled.
    L_DEBUG = 0x00000001,  ///< Program execution tracing messages.
    L_INFO = 0x00000002,  ///< Informational, just for interest.
    L_WARNING = 0x00000004,  ///< For warnings, bad things but recoverable.
    L_ERROR = 0x00000008,  ///< For errors that can't be recovered from.
    L_ALL = 0xFFFFFFFF  ///< All debug LLs are enabled.
};

enum ImplLogCategory
{
    C_NONE = 0x00000000,
    C_INDEXER = 0x00000001,
    C_QUERY = 0x00000002,
    C_OPTIMIZER = 0x00000004,
    C_DICTIONARY = 0x00000008,
    C_CONTAINER = 0x00000010,
    C_ALL = 0xFFFFFFFF
};

void implSetLogLevel(ImplLogLevel level, bool enabled);
void implSetLogCategory(ImplLogCategory category, bool enabled);
bool isLogEnabled(ImplLogCategory category, ImplLogLevel level);
void log(DbEnv *environment, ImplLogCategory category, ImplLogLevel level, const char *container, const char *message);
}

#endif

