//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: KeyStatistics.hpp,v 1.21 2003/05/23 18:24:34 merrells Exp $
//

#ifndef __KEYSTATISTICS_HPP
#define	__KEYSTATISTICS_HPP

#include <string>

namespace DbXml
{
class DbtOut;

class KeyStatistics
{
public:
	KeyStatistics();

	// default implementations are fine.
	// ~KeyStatistics();
	// KeyStatistics(const KeyStatistics&);
	// KeyStatistics & operator = (const KeyStatistics &);

	void add(const KeyStatistics& es);
	double averageKeyValueSize() const;
	void zero();

	void setThisFromDbt(const DbtOut &dbt, bool swap);
	void setDbtFromThis(DbtOut &dbt, bool swap) const;

	std::string asString() const;

	signed long numIndexedKeys_;
	signed long numUniqueKeys_;
	signed long sumKeyValueSize_;
};

std::ostream& operator<<(std::ostream& s, const KeyStatistics &ks);

}

#endif

