//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: IDS.hpp,v 1.11 2003/05/09 00:01:47 mjc Exp $
//

#ifndef __IDSET_HPP
#define	__IDSET_HPP

#include <algorithm>
#include <string>
#include <vector>
#include "ID.hpp"
#include "shared_ptr.hpp"

namespace DbXml
{

class IDS
{
public:
	typedef std::vector<ID>::iterator iterator;
	typedef std::vector<ID>::const_iterator const_iterator;
	typedef shared_ptr<IDS> SharedPtr;
	IDS(size_t reserve = 64)
	{
		ids.reserve(reserve);
	}
	// ~IDS(); default is ok
	std::string toString() const;
	iterator begin()
	{
		return ids.begin();
	}
	iterator end()
	{
		return ids.end();
	}
	const_iterator begin() const
	{
		return ids.begin();
	}
	const_iterator end() const
	{
		return ids.end();
	}
	long size() const
	{
		return ids.size();
	}
	void push_back(ID id)
	{
		ids.push_back(id);
	}
	void set_union(SharedPtr &a, SharedPtr &b)
	{
		ids.reserve(a->size() + b->size());
		std::set_union(a->begin(), a->end(), b->begin(), b->end(), std::back_inserter(ids));
	}
	void set_intersection(SharedPtr &a, SharedPtr &b)
	{
		ids.reserve(a->size() < b->size() ? a->size() : b->size());
		std::set_intersection(a->begin(), a->end(), b->begin(), b->end(), std::back_inserter(ids));
	}
	void sort()
	{
		std::sort(begin(), end());
	}
	void unique()
	{
		std::vector<ID>::iterator i = std::unique(begin(), end());
		ids.resize(i - begin());
	}
	void clear()
	{
		ids.clear();
	}
	std::vector<ID> ids;
private:
	// no need for copy and assignment
	IDS(const IDS&);
	IDS &operator=(const IDS &);
};

}

#endif

