//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: ID.hpp,v 1.18 2003/05/09 00:01:46 mjc Exp $
//

#ifndef __ID_HPP
#define	__ID_HPP

#include <iosfwd>

class Dbt;

namespace DbXml
{

class DbtOut;

class ID
{
public:
	ID() : id_(0)
	{}
	ID(unsigned long id) : id_(id)
	{ }
	void reset()
	{
		id_ = 0;
	}
	unsigned long raw() const
	{
		return id_;
	}
	void setThisFromDbt(const Dbt &dbt, bool swap);
	void setDbtFromThis(DbtOut &dbt, bool swap) const;
	int operator==(const ID &o) const
	{
		return id_ == o.id_;
	}
	int operator==(unsigned long id) const
	{
		return id_ == id;
	}
	int operator!=(const ID &o) const
	{
		return id_ != o.id_;
	}
	int operator!=(unsigned long id) const
	{
		return id_ != id;
	}
	bool operator<(const ID &o) const
	{
		return id_ < o.id_;
	}
	// default implementation
	// ID(const ID&);
	// void operator=(const ID &);
private:
	unsigned long id_;
};

std::ostream& operator<<(std::ostream& s, ID id);

}

#endif

