//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: ID.cpp,v 1.12 2003/05/09 00:01:46 mjc Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "ID.hpp"
#include "ScopedDbt.hpp"

#include "db_utils.h"

using namespace DbXml;

void ID::setThisFromDbt(const Dbt &dbt, bool swap)
{
	id_ = *(reinterpret_cast<unsigned long*>(dbt.get_data())); // copies the data
	if (swap) {
		M_32_SWAP(id_);
	}
}

void ID::setDbtFromThis(DbtOut &dbt, bool swap) const
{
	dbt.set(&id_, sizeof(id_)); // copies the data
	if (swap) {
		unsigned long *p = reinterpret_cast<unsigned long*>(dbt.get_data());
		M_32_SWAP(*p);
	}
}

std::ostream& DbXml::operator<<(std::ostream& s, ID id)
{
	return s << id.raw();
}
