//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlUpdateContext.hpp,v 1.5 2003/05/09 00:01:42 mjc Exp $
//

#ifndef __XMLUPDATECONTEXT_HPP
#define	__XMLUPDATECONTEXT_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"
#include <string>

namespace DbXml
{

class UpdateContext;

class DBXML_EXPORT XmlUpdateContext
{
public:
	XmlUpdateContext(XmlContainer &container);
	virtual ~XmlUpdateContext();
	XmlUpdateContext(const XmlUpdateContext&);
	XmlUpdateContext &operator=(const XmlUpdateContext &);

	// private
	operator class UpdateContext&()
	{
		return *updateContext_;
	}
	const XmlContainer &getContainer() const
	{
		return container_;
	}

private:
	XmlContainer &container_;
	class UpdateContext *updateContext_;
};

}

#endif

