//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlQueryExpression.hpp,v 1.22 2003/05/12 23:13:58 merrells Exp $
//

#ifndef __XPATHEXPRESSION_HPP
#define	__XPATHEXPRESSION_HPP

#include "DbXmlFwd.hpp"
#include "XmlPortability.hpp"
#include <string>

namespace DbXml
{

class QueryExpression;

class DBXML_EXPORT XmlQueryExpression
{
public:
	virtual ~XmlQueryExpression();
	XmlQueryExpression(const XmlQueryExpression&);
	XmlQueryExpression &operator=(const XmlQueryExpression &);
	std::string getXPathQuery() const;

	// private
	XmlQueryExpression(const XmlContainer &container, XmlQueryContext &context);
	operator QueryExpression &() const
	{
		return *expression_;
	}
	XmlQueryContext &getQueryContext() const
	{
		return *context_;
	}
	const XmlContainer &getContainer() const
	{
		return *container_;
	}

private:
	const XmlContainer *container_;
	XmlQueryContext *context_;
	QueryExpression *expression_;
};

}

#endif

