//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlModify.hpp,v 1.3 2003/12/04 21:52:42 merrells Exp $
//

#ifndef __XMLMODIFY_HPP
#define __XMLMODIFY_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"
#include <string>

namespace DbXml
{

class Modify;

class DBXML_EXPORT XmlModify
{
public:
	enum ModificationType {
		InsertAfter,  // type dependent
		InsertBefore, // type dependent
		Append,       // type dependent (uses location argument)
		Update,       // requires content
		Remove,       // needs no other information
		Rename,       // requires name
		Empty
	};
	enum XmlObject {
		Element,   // requires name
		Attribute, // requires name
		Text,      // requires content
		ProcessingInstruction,  // requires name and content
		Comment,   // requires content
		None
	};

	XmlModify(const std::string &xpath, ModificationType operation, XmlObject type,
		  const std::string &name, const std::string &content, int location = -1,
		  XmlQueryContext *context = 0);
	XmlModify(XmlQueryExpression &expression, ModificationType operation, XmlObject type,
		  const std::string &name, const std::string &content, int location = -1);
	~XmlModify();

	// return the number of modification operations performed
	int getNumModifications() const;
	// optionally rewrite content with new encoding
	void setNewEncoding(const std::string &newEncoding);

	// private
	operator Modify &() const
	{
		return *modify_;
	}
private:
	Modify *modify_;
};


}
#endif
