//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlIndexSpecification.hpp,v 1.3 2003/05/09 00:01:41 mjc Exp $
//

#ifndef __XMLINDEXSPECIFICATION_HPP
#define	__XMLINDEXSPECIFICATION_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"

#include <string>

namespace DbXml
{

class IndexSpecification;
class IndexSpecificationIterator;

class DBXML_EXPORT XmlIndexSpecification
{
public:
	XmlIndexSpecification();
	virtual ~XmlIndexSpecification();
	XmlIndexSpecification(const XmlIndexSpecification &);
	XmlIndexSpecification &operator=(const XmlIndexSpecification &);

	void addIndex(const std::string &uri, const std::string &name, const std::string &index);
	void deleteIndex(const std::string &uri, const std::string &name, const std::string &index);
	void replaceIndex(const std::string &uri, const std::string &name, const std::string &index);

	bool find(const std::string &uri, const std::string &name, std::string &index);
	bool next(std::string &uri, std::string &name, std::string &index);
	void reset();

	// private
	operator IndexSpecification &()
	{
		return *is_;
	}
	operator const IndexSpecification &() const
	{
		return *is_;
	}

private:
	IndexSpecification *is_;
	IndexSpecificationIterator *isi_;
};

}

#endif

