//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlContainer.hpp,v 1.63 2003/12/01 15:51:54 gmf Exp $
//

#ifndef __XMLCONTAINER_HPP
#define	__XMLCONTAINER_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"
#include <dbxml/XmlDocument.hpp> // for XmlDocument enums

#include <string>
#include <db_cxx.h>

namespace DbXml
{

#define DBXML_CHKSUM 0x04000000 // mapped onto db->set_flags(DB_CHKSUM);
#define DBXML_ENCRYPT 0x08000000 // mapped onto db->set_flags(DB_ENCRYPT);

class Container;
class XmlModify;
	
class DBXML_EXPORT XmlContainer
{
public:
	XmlContainer(DbEnv *environment, const std::string &name, u_int32_t flags = 0);
	virtual ~XmlContainer();
	void setPageSize(u_int32_t pagesize);
	void open(DbTxn *txn, u_int32_t flags = 0, int mode = 0);
	bool exists(DbTxn *txn);
	bool isOpen() const;
	void close(u_int32_t flags = 0);
	void setIndexSpecification(DbTxn *txn, const XmlIndexSpecification &index);
	XmlIndexSpecification getIndexSpecification(DbTxn *txn) const;
	void addIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	void deleteIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	void replaceIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	const std::string &getName() const;
	void setName(const std::string &name);
	u_int32_t putDocument(DbTxn *txn, XmlDocument &document, XmlUpdateContext *context = 0, u_int32_t flags = 0);
	XmlDocument getDocument(DbTxn *txn, u_int32_t id, u_int32_t flags = 0);
	void deleteDocument(DbTxn *txn, u_int32_t id, XmlUpdateContext *context = 0, u_int32_t flags = 0);
	void deleteDocument(DbTxn *txn, XmlDocument &document, XmlUpdateContext *context = 0, u_int32_t flags = 0);
	void updateDocument(DbTxn *txn, XmlDocument &document, XmlUpdateContext *context = 0);
	XmlQueryExpression parseXPathExpression(DbTxn *txn, const std::string &xpath, XmlQueryContext *context = 0) const;
	XmlResults queryWithXPath(DbTxn *txn, const std::string &xpath, XmlQueryContext *context = 0, u_int32_t flags = 0) const;
	XmlResults queryWithXPath(DbTxn *txn, XmlQueryExpression &xpath, u_int32_t flags = 0) const;
	void modifyDocument(DbTxn *txn, const XmlModify &xmlModify, XmlUpdateContext *context = 0, u_int32_t flags = 0);
	void remove(DbTxn *txn, u_int32_t flags = 0);
	void rename(DbTxn *txn, const std::string &newName, u_int32_t flags = 0);
	void dump(std::ostream *out, u_int32_t flags = 0);
	void load(std::istream *in, unsigned long *lineno, u_int32_t flags = 0);
	void verify(std::ostream *out, u_int32_t flags = 0);
	void upgrade(u_int32_t flags = 0);

	// private
	operator Container *();
	DbEnv *getEnvironment();
	void setResolver(const XmlResolver *resolver); // WARNING: This method is experimental and undocumented!

private:
	XmlContainer(const XmlContainer &);
	XmlContainer &operator=(const XmlContainer &);

	void checkFlags(const char *function, u_int32_t flags, u_int32_t mask) const; // throws XmlException
	void checkState(const char *function, bool open) const; // throws XmlException
	void checkContainer(const char *function, const char *objectclass, const XmlContainer &container) const; // throws XmlException

	class TransactedContainer *container_;
};

}

#endif

