//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: DbXmlFwd.hpp,v 1.26 2004/01/27 15:04:24 gmf Exp $
//

#ifndef __DBXMLFWD_HPP
#define	__DBXMLFWD_HPP

// BEGIN-DBXML-VERSION
/* DO NOT EDIT: automatically built by dist/s_include. */
#define DBXML_VERSION_MAJOR 1
#define DBXML_VERSION_MINOR 2
#define DBXML_VERSION_PATCH 1
#define DBXML_VERSION_STRING "Sleepycat Software: Berkeley DB XML 1.2.1: (January 27, 2004)"
// END-DBXML-VERSION

#include "XmlPortability.hpp"

class Dbt;

namespace DbXml
{
class XmlContainer;
class XmlDocument;
class XmlExcepion;
class XmlQueryContext;
class XmlUpdateContext;
class XmlResults;
class XmlValue;
class XmlQueryExpression;
class XmlIndexSpecification;
class XmlResolver;
class XmlModify;

enum LogLevel
{
    LEVEL_NONE = 0x00000000,  ///< No debug levels are enabled.
    LEVEL_DEBUG = 0x00000001,  ///< Program execution tracing messages.
    LEVEL_INFO = 0x00000002,  ///< Informational, just for interest.
    LEVEL_WARNING = 0x00000004,  ///< For warnings, bad things but recoverable.
    LEVEL_ERROR = 0x00000008,  ///< For errors that can't be recovered from.
    LEVEL_ALL = 0xFFFFFFFF  ///< All debug levels are enabled.
};

enum LogCategory
{
    CATEGORY_NONE = 0x00000000,
    CATEGORY_INDEXER = 0x00000001,
    CATEGORY_QUERY = 0x00000002,
    CATEGORY_OPTIMIZER = 0x00000004,
    CATEGORY_DICTIONARY = 0x00000008,
    CATEGORY_CONTAINER = 0x00000010,
    CATEGORY_ALL = 0xFFFFFFFF
};

DBXML_EXPORT const char *dbxml_version(int *majorp, int *minorp, int *patchp);

DBXML_EXPORT void setLogLevel(LogLevel level, bool enabled);

DBXML_EXPORT void setLogCategory(LogCategory category, bool enabled);
}

#endif
