package com.sleepycat.dbxml.examples.gettingStarted;

import java.io.*;
import com.sleepycat.dbxml.examples.gettingStarted.myDbEnv;
import com.sleepycat.dbxml.examples.gettingStarted.myXmlContainer;

import com.sleepycat.dbxml.*;
import com.sleepycat.db.*;

class simpleAdd
{
    
    private static String theContainer = "simpleExampleData.dbxml";
    private static void usage()
    {
         String usageMessage = "\nThis program adds a few simple XML documents to a specified container.\n";
                usageMessage += "You should run exampleLoadContainer before running this example.\n";
                usageMessage += "You are only required to pass this command the path location of the database\n";
                usageMessage += "environment that you specified when you loaded the examples data:\n\n";

                usageMessage += "\t-h <dbenv directory>\n";

                usageMessage += "For example:\n";
                usageMessage += "\tjava com.sleepycat.dbxml.examples.gettingStarted.simpleAdd -h examplesEnvironment\n";

         System.out.println(usageMessage);
         System.exit( -1 );
    }


    public static void main(String args[]) throws Throwable
    {
       File path2DbEnv = null;

       for(int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
               switch(args[i].charAt(1)) {
                    case 'h':
                         path2DbEnv = new File(args[++i]);
                         break;
                    default:
                    usage();
               }
            } 
       }

       if (path2DbEnv == null || ! path2DbEnv.isDirectory()) {
            usage();
       }


       myDbEnv theDBEnv = null;
       myXmlContainer openedContainer = null;
       DbTxn txn = null;
       try
       {
            //Opne a database environment
            theDBEnv = new myDbEnv(path2DbEnv);
            //Open a container in that environment
            openedContainer = new myXmlContainer(theContainer, theDBEnv);

            //Get a transaction
            txn = theDBEnv.getDbEnv().txnBegin(null, 0);

            //XML documents must be stored in a String before they can be added to the container
            String document1 = "<aDoc><title>doc1</title><color>green</color></aDoc>";
            String document2 = "<aDoc><title>doc2</title><color>yellow</color></aDoc>";

            //Instantiate an XmlDocument object
            XmlDocument myXMLDoc = new XmlDocument();

            //Set the XmlDocument to the relevant string and then put it 
            // into the container.
            myXMLDoc.setContent(document1);
            openedContainer.getContainer().putDocument(txn, myXMLDoc, null, 0);

            //Do it again for the second document
            myXMLDoc.setContent(document2);
            openedContainer.getContainer().putDocument(txn, myXMLDoc, null, 0);

            //Commit the writes. This causes the container write operations
            //  to be saved to the container.
            txn.commit(0);

       } catch (Exception e) {

            System.err.println("Error performing document add against " + theContainer);
            System.err.println("   Message: " + e.getMessage() );
            if ( txn != null ) {
               txn.abort();
            }
            throw e;

       } finally {
            if (openedContainer != null) {
               openedContainer.cleanup();
            }

            if (theDBEnv != null) {
               theDBEnv.cleanup();
            }
       }

    } //End main

}
