package com.sleepycat.dbxml.examples.gettingStarted;

import java.io.*;
import java.util.*;

import com.sleepycat.db.*;

//Class used to open and close a Berkeley DB environment
public class myDbEnv
{
    public myDbEnv(File path2DbEnv) throws Throwable
    {
      if (! path2DbEnv.isDirectory()) {
        throw new Exception(path2DbEnv.getPath() + " does not exist or is not a directory.");
      }

     dbEnv_ = new DbEnv(0);
     //Redirect debugging information to System.err
     dbEnv_.setErrorStream(System.err);

     //Open the environment
     dbEnv_.open(path2DbEnv.getPath(), cFlags_, 0);

     //Boolean used to know whether to close the environment
     // when the cleanup() method is called.
     dbEnvIsOpen_ = true;
     path2DbEnv_ = path2DbEnv;
    }


    //Returns the path to the database environment
    public File getDbEnvPath() { return path2DbEnv_; }

    //Returns the database environment encapsulated by this class.
    public DbEnv getDbEnv() { return dbEnv_; }

    //Used to close the environment
    public void cleanup() throws Throwable
    {
       if (dbEnvIsOpen_) {
            dbEnv_.close( 0 );
            dbEnvIsOpen_ = false;
       }
    }

    private DbEnv dbEnv_ = null;
    private int cFlags_ = Db.DB_CREATE|Db.DB_INIT_LOCK|Db.DB_INIT_LOG|Db.DB_INIT_MPOOL|Db.DB_INIT_TXN;
    private boolean dbEnvIsOpen_ = false;
    private File path2DbEnv_ = null;


}
