// Tcl-specific SWIG directives
%module dbxml_tcl
%{
extern "C" void *_NameToPtr(const char *);
#define NAME_TO_ENV(name) (DB_ENV *)_NameToPtr((name))
#define NAME_TO_TXN(name) (DB_TXN *)_NameToPtr((name))
%}

%typemap(tcl8, out) u_int32_t * {
	for (int i = 0; $1[i]; i++)
		Tcl_ListObjAppendElement(interp, $result, Tcl_NewIntObj($1[i]));
	delete [] $1;
}

%typemap(tcl8, in) DbEnv * {
	char *arg = Tcl_GetStringFromObj($input, NULL);
	DB_ENV *envp = NAME_TO_ENV(arg);
	$1 = envp ? DbEnv::wrap_DB_ENV(envp) : NULL;
}

%typemap(tcl8, in) DbTxn * {
	char *arg = Tcl_GetStringFromObj($input, NULL);
	DB_TXN *txnp = NAME_TO_TXN(arg);
	$1 = txnp ? DbTxn::wrap_DB_TXN(txnp) : 0;
}

%typemap(tcl8, in) Dbt *, Dbt & (Dbt dbt) {
	int len;
	char *data = (char *)Tcl_GetByteArrayFromObj($input, &len);
	dbt.set_data(data);
	dbt.set_size(len);
	$1 = &dbt;
}

%typemap(tcl8, out) const Dbt * {
	if ($1)
		Tcl_SetObjResult(interp, Tcl_NewByteArrayObj((unsigned char *)$1->get_data(), $1->get_size()));
	else
		Tcl_SetResult(interp, (char *) "", TCL_STATIC);
}

%exception {
	try {
		$function
	} catch (XmlException &e) {
		Tcl_SetResult(interp, (char *)e.what(), TCL_VOLATILE);
		return TCL_ERROR;
	}
}
