/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef __PATHAN_XPATHEVALUATOREXT_HPP
#define __PATHAN_XPATHEVALUATOREXT_HPP

#include "../Pathan.hpp"

#include <xercesc/dom/DOM.hpp>

#include "../XPathEvaluator.hpp"

class PATHAN_EXPORT XPathEvaluatorExt : public XPathEvaluator
{
public:

  virtual ~XPathEvaluatorExt();
  
  virtual void setGlobalVar(const XMLCh *name, const XMLCh *value) = 0;
  virtual void setGlobalVar(const XMLCh *name, bool value) = 0;
  virtual void setGlobalVar(const XMLCh *name, double value) = 0;
  virtual void setGlobalVar(const XMLCh *name, XERCES_CPP_NAMESPACE_QUALIFIER DOMNodeList *value) = 0;
  virtual void setGlobalVar(const XMLCh *name, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *value) = 0;

protected:

  XPathEvaluatorExt();
  XPathEvaluatorExt(const XPathEvaluatorExt& other);
  XPathEvaluatorExt& operator=(const XPathEvaluatorExt& other);
}; //XPathEvaluatorExt

#endif //__PATHAN_XPATHEVALUATOREXT_HPP
