/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef __PATHAN_XPATHRESULT_HPP
#define __PATHAN_XPATHRESULT_HPP

#include "Pathan.hpp"

#include <xercesc/dom/DOM.hpp>

#include "XPathException.hpp"

class PATHAN_EXPORT XPathResult
{
public:

  enum resultType {
    ANY_TYPE                     = 0,
    NUMBER_TYPE                  = 1,
    STRING_TYPE                  = 2,
    BOOLEAN_TYPE                 = 3,
    UNORDERED_NODE_ITERATOR_TYPE = 4,
    ORDERED_NODE_ITERATOR_TYPE   = 5,
    UNORDERED_NODE_SNAPSHOT_TYPE = 6,
    ORDERED_NODE_SNAPSHOT_TYPE   = 7,
    ANY_UNORDERED_NODE_TYPE      = 8,
    FIRST_ORDERED_NODE_TYPE      = 9
  };

  XPathResult();
  virtual ~XPathResult();

  virtual XPathResult::resultType getResultType() const = 0;

  virtual double getNumberValue() const throw (XPathException) = 0;

  virtual const XMLCh* getStringValue() const throw (XPathException) = 0;

  virtual bool getBooleanValue() const throw (XPathException) = 0;

  virtual XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* getSingleNodeValue() const throw (XPathException) = 0;

  virtual bool getInvalidIteratorState() const = 0;

  virtual unsigned long getSnapshotLength() const throw(XPathException) = 0;

  virtual XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* iterateNext() throw (XPathException, XERCES_CPP_NAMESPACE_QUALIFIER DOMException) = 0;

  virtual XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* snapshotItem(unsigned long index) const throw(XPathException) = 0;

protected:

  XPathResult(const XPathResult& other);
  XPathResult& operator=(const XPathResult& other);
}; //XPathResult

#endif //__PATHAN_XPATHRESULT_HPP


