/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef __PATHAN_XPATHNAMESPACE_HPP
#define __PATHAN_XPATHNAMESPACE_HPP

#include "Pathan.hpp"

#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMElement.hpp>

//Should be XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::NodeType XPATH_NAMESPACE_NODE = 13
#define XPATH_NAMESPACE_NODE 13

//Should be XERCES_CPP_NAMESPACE_QUALIFIER DOMDocumentImpl::NodeObjectType XPATH_NAMESPACE_OBJECT = 13
#define XPATH_NAMESPACE_OBJECT 13

class PATHAN_EXPORT XPathNamespace : public XERCES_CPP_NAMESPACE_QUALIFIER DOMNode
{
public:

  //Destructor
  virtual ~XPathNamespace() {};

  //Returns the associated element for this namespace binding
  virtual XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* getOwnerElement(void) const = 0;

protected:

  //Null constructor
  XPathNamespace() {}

  //Copy constructor
  XPathNamespace(const XPathNamespace &other) {}

  //Assignment operators
  XPathNamespace& operator=(const XPathNamespace& other) {return *this;}

  //Used by XPathNamespaceImpl in node creation
  XPathNamespace(class XPathNamespaceImpl* impl);
};//XPathNamespace

#endif //__PATHAN_XPATHNAMESPACE_HPP
