/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef __PATHAN_XPATHEXPRESSION_HPP
#define __PATHAN_XPATHEXPRESSION_HPP

#include "Pathan.hpp"

#include <xercesc/dom/DOM.hpp>

#include "XPathResult.hpp"

class PATHAN_EXPORT XPathExpression
{
public:

  virtual ~XPathExpression();

  virtual XPathResult* evaluate(XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*                      contextNode,
                                const XPathResult::resultType type,
                                XPathResult*                  result) const
    throw (XPathException, XERCES_CPP_NAMESPACE_QUALIFIER DOMException) = 0;

protected:

  XPathExpression();
  XPathExpression(const XPathExpression& other);
  XPathExpression& operator=(const XPathExpression& other);
};//XPathExpression

#endif //__PATHAN_XPATHEXPRESSION_HPP
