/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

XPathException - exception class for xpath, as suggested in DOM Level 3 XPath Specification

*/

#ifndef __PATHAN_XPATHEXCEPTION_HPP
#define __PATHAN_XPATHEXCEPTION_HPP

#include "Pathan.hpp"

#include <string>

class PATHAN_EXPORT XPathException
{
public:

  enum XPathExceptionCode {
    INVALID_EXPRESSION_ERR = 1,
    TYPE_ERR = 2
  };

  XPathException(const XPathExceptionCode code,
                 const std::string&       message);
  ~XPathException();

  const XPathExceptionCode getCode() const;
  const std::string& getString() const;

private:

  XPathExceptionCode _code;
  std::string _message;

};//XPathException

#endif //__PATHAN_XPATHEXCEPTION_HPP
