/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef __PATHAN_XPATHEVALUATOR_HPP
#define __PATHAN_XPATHEVALUATOR_HPP

#include "Pathan.hpp"

#include <xercesc/dom/DOM.hpp>

#include "XPathExpression.hpp"
#include "XPathResult.hpp"
#include "XPathNSResolver.hpp"

class PATHAN_EXPORT XPathEvaluator
{
public:

  virtual ~XPathEvaluator();

  virtual XPathExpression* createExpression(const XMLCh*           expression,
                                            const XPathNSResolver* resolver) const
    throw (XPathException, XERCES_CPP_NAMESPACE_QUALIFIER DOMException) = 0;

  virtual XPathNSResolver* createNSResolver(XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *nodeResolver) const = 0;

  virtual XPathResult* evaluate(const XMLCh*                  expression,
                                XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*                      contextNode,
                                const XPathNSResolver*        resolver,
                                const XPathResult::resultType type,
                                XPathResult*                  result) const
    throw (XPathException, XERCES_CPP_NAMESPACE_QUALIFIER DOMException) = 0;

  // This method should be used to create an XPathEvaluator. This should be
  // move to Xerces XERCES_CPP_NAMESPACE_QUALIFIER XERCES_CPP_NAMESPACE_QUALIFIER DOMImplementation or something
  static XPathEvaluator* createEvaluator();

protected:

  XPathEvaluator();
  XPathEvaluator(const XPathEvaluator& other);
  XPathEvaluator& operator=(const XPathEvaluator& other);
}; //XPathEvaluator

#endif //__PATHAN_XPATHEVALUATOR_HPP
