//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlResults.hpp,v 1.27 2003/10/13 20:19:49 gmf Exp $
//

#ifndef __XMLRESULTS_HPP
#define	__XMLRESULTS_HPP

#include "DbXmlFwd.hpp"
#include "XmlPortability.hpp"
#include <string>

class DbTxn;

namespace DbXml
{

class Results;

class DBXML_EXPORT XmlResults
{
public:
	virtual ~XmlResults();
	XmlResults(const XmlResults&);
	XmlResults &operator=(const XmlResults &);
	bool next(XmlValue &value);
	bool next(XmlDocument &document);
	bool next(XmlDocument &document, XmlValue &value);
	void reset();
	size_t size() const;
	void add(const XmlValue &value);
	// private
	XmlResults(XmlQueryContext &context, DbTxn *txn);
	operator Results *()
	{
		return results_;
	}
	operator Results &()
	{
		return *results_;
	}
	// deprecated next() methods
	bool next(DbTxn *txn, XmlValue &value);
	bool next(DbTxn *txn, XmlDocument &document);
	bool next(DbTxn *txn, XmlDocument &document, XmlValue &value);
private:
	XmlQueryContext *context_;
	Results *results_;
};

}

#endif

