//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlQueryContext.hpp,v 1.22 2003/12/08 01:37:22 gmf Exp $
//

#ifndef __XMLQUERYCONTEXT_HPP
#define	__XMLQUERYCONTEXT_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"
#include <string>

namespace DbXml
{

class QueryContext;

class DBXML_EXPORT XmlQueryContext
{
public:
	enum ReturnType
	{
	    ResultDocuments,  ///< Return documents that match the XPath expression.
	    ResultValues,  ///< Return nodes from the documents that match the XPath expression.
	    CandidateDocuments, ///< Return documents that may match the XPath expression.
		ResultDocumentsAndValues ///< Return documents and nodes that match the XPath expression.
	};

	enum EvaluationType
	{
	    Eager,  ///< Evaluate the whole query immediatly.
	    Lazy ///< Evaluate the query as the result set is iterated over.
	};

	explicit XmlQueryContext(ReturnType rt = ResultDocuments, EvaluationType et = Eager);
	virtual ~XmlQueryContext();
	XmlQueryContext(const XmlQueryContext&);
	XmlQueryContext &operator=(const XmlQueryContext &);
	void setNamespace(const std::string &prefix, const std::string &uri);
	std::string getNamespace(const std::string &prefix);
	void removeNamespace(const std::string &prefix);
	void clearNamespaces(void);
	void setVariableValue(const std::string &name, const XmlValue &value);
	bool getVariableValue(const std::string &name, XmlValue &value) const;
	void setWithMetaData(bool withMetaData);
	bool getWithMetaData(void) const;
	void setReturnType(ReturnType rt = ResultDocuments);
	ReturnType getReturnType() const;
	void setEvaluationType(EvaluationType et = Eager);
	EvaluationType getEvaluationType() const;

	// private
	operator const QueryContext *() const
	{
		return queryContext_;
	}
	operator QueryContext &() const
	{
		return *queryContext_;
	}
	operator QueryContext *()
	{
		return queryContext_;
	}

private:
	QueryContext *queryContext_;
};

}

#endif

