//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlDocument.hpp,v 1.33 2003/12/01 15:51:54 gmf Exp $
//

#ifndef __XMLDOCUMENT_HPP
#define	__XMLDOCUMENT_HPP

#include "XmlPortability.hpp"
#include "DbXmlFwd.hpp"
#include <string>
#include <db_cxx.h>

#if defined(DBXML_DOM_XERCES2)
#include <xercesc/dom/DOM.hpp>

#if !defined(XERCES_CPP_NAMESPACE_QUALIFIER)
 #define XERCES_CPP_NAMESPACE_QUALIFIER
#endif
#endif

namespace DbXml
{

class Document;
class XmlModify;

class DBXML_EXPORT XmlDocument
{
public:
	XmlDocument();
	virtual ~XmlDocument();
	XmlDocument(const XmlDocument&);
	XmlDocument &operator=(const XmlDocument &);
	u_int32_t getID() const;
	void setName(const std::string &name);
	std::string getName() const;
	void setContent(const std::string &content);
	void setContent(Dbt &content);
	const Dbt *getContent() const;
	void setMetaData(const std::string &uri, const std::string &prefix, const std::string &name, const XmlValue &value);
	bool getMetaData(const std::string &uri, const std::string &name, XmlValue &value);
	void setMetaData(const std::string &uri, const std::string &prefix, const std::string &name, const Dbt &value);
	bool getMetaData(const std::string &uri, const std::string &name, Dbt &value);
#if defined(DBXML_DOM_XERCES2)
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *getDOM(bool withMetaData, bool adopt=false) const;
#endif

	std::string &getContentAsString(std::string &content) const;
	XmlResults queryWithXPath(const std::string &xpath, XmlQueryContext *context = 0) const;
	XmlResults queryWithXPath(XmlQueryExpression &xpath) const;
	void modifyDocument(const XmlModify &xmlModify);

	// private
	operator Document &()
	{
		return *document_;
	}
	operator const Document &() const
	{
		return *document_;
	}

	bool operator == (const XmlDocument &other) const
	{
		return (document_ == other.document_);
	}
	bool operator != (const XmlDocument &other) const
	{
		return (document_ != other.document_);
	}
private:

	Document *document_;
};

}

#endif
