package com.sleepycat.dbxml.examples.gettingStarted;

import java.io.*;
import com.sleepycat.dbxml.examples.gettingStarted.myDbEnv;
import com.sleepycat.dbxml.examples.gettingStarted.myXmlContainer;

import com.sleepycat.dbxml.*;
import com.sleepycat.db.*;

class simpleQuery
{
    
    private static String theContainer = "simpleExampleData.dbxml";
    private static void usage()
    {
         String usageMessage = "\nThis program performs various XPath queries against a DBXML container.\n";
                usageMessage += "You should run exampleLoadContainer before running this example.\n";
                usageMessage += "You are only required to pass this command the path location of the database\n";
                usageMessage += "environment that you specified when you loaded the examples data:\n\n";

                usageMessage += "\t-h <dbenv directory>\n";

                usageMessage += "For example:\n";
                usageMessage += "\tjava com.sleepycat.dbxml.examples.gettingStarted.simpleQuery -h examplesEnvironment\n";

         System.out.println(usageMessage);
         System.exit( -1 );
    }

    private static void doQuery( XmlContainer container, String XPath ) throws Throwable
    {
       //Perform a single query against the referenced container.
       // No context is used for this query.
       System.out.println("Exercising query: '" + XPath + "'.");
       System.out.println("Return to continue: ");
       System.in.read();

       //Perform the query
       XmlResults results = container.queryWithXPath(null, XPath, null, 0);
       //Iterate over the results of the query using an XmlValue object
       XmlValue value = new XmlValue();
       while ((value = results.next()) != null){
            System.out.println(value.asString(null));
       }
       System.out.println(results.size() + " results returned for query '" + XPath + "'.");
    }


    public static void main(String args[]) throws Throwable
    {

       File path2DbEnv = null;
       for(int i = 0; i < args.length; ++i) 
       {
            if (args[i].startsWith("-")) {
               switch(args[i].charAt(1)) {
                    case 'h':
                         path2DbEnv = new File(args[++i]);
                         break;
                    default:
                    usage();
               }
            } 
       }


       if (path2DbEnv == null || ! path2DbEnv.isDirectory()) {
            usage();
       }


       myDbEnv theDBEnv = null;
       myXmlContainer openedContainer = null;
       try
       {
            //Open a database environment
            theDBEnv = new myDbEnv(path2DbEnv);
            //Open a container in that environment
            openedContainer = new myXmlContainer(theContainer, theDBEnv);

            //Find all the Vendor documents in the database
            doQuery(openedContainer.getContainer(), "/vendor");

            //Find all the vendors that are wholesale shops
            doQuery(openedContainer.getContainer(), "/vendor[@type=\"wholesale\"]");

            //Find the product document for "Lemon Grass"
            doQuery(openedContainer.getContainer(), "/product/item[text()=\"Lemon Grass\"]");

            //Find all the products where the price is less than or equal to 0.11
            doQuery(openedContainer.getContainer(), "/product/inventory[number(price)<=0.11]");
    
            //Find all the vegetables where the price is less than or equal to 0.11
            doQuery(openedContainer.getContainer(), "/product[number(inventory/price)<=0.11 and category/text()=\"vegetables\"]");

       } catch (Exception e) {

            System.err.println("Error performing query against " + theContainer);
            System.err.println("   Message: " + e.getMessage());
            throw e;

       } finally {
            if (openedContainer != null) {
               openedContainer.cleanup();
            }

            if (theDBEnv != null) {
               theDBEnv.cleanup();
            }
       }

    } //End main
}
