package com.sleepycat.dbxml.examples.gettingStarted;

import java.io.*;

import com.sleepycat.dbxml.*;
import com.sleepycat.db.*;

//Exception handling omitted for clarity


//Very simple program that opens (creates) a database environment and
// then opens several containers in that environment.
class simpleContainerInEnv
{
    public static void main(String args[]) throws Throwable
    {

       //Create and open a database environment. This is a very simple example.
       // See myDbEnv.java for a more robust example.
       DbEnv env = new DbEnv(0);

       //The path the directory where you want to place the environment
       // must exist!!
       String environmentPath = "/path/to/environment/directory";

       //Open the environment.
       env.open(environmentPath, Db.DB_CREATE|Db.DB_INIT_MPOOL, 0);

       int CFLAGS = Db.DB_CREATE;
       //Create containers in the environment
       XmlContainer myContainer1 = new XmlContainer(env, "container1.dbxml", 0);
       myContainer1.open(null, CFLAGS, 0);

       XmlContainer myContainer2 = new XmlContainer(env, "container2.dbxml", 0);
       myContainer2.open(null, CFLAGS, 0);

       XmlContainer myContainer3 = new XmlContainer(env, "container3.dbxml", 0);
       myContainer3.open(null, CFLAGS, 0);

       //Close the containers.
       myContainer1.close(0);
       myContainer2.close(0);
       myContainer3.close(0);

	   env.close(0);
    }

}
