package com.sleepycat.dbxml.examples.gettingStarted;

import java.io.*;
import com.sleepycat.dbxml.examples.gettingStarted.myDbEnv;
import com.sleepycat.dbxml.examples.gettingStarted.myXmlContainer;

import com.sleepycat.dbxml.*;
import com.sleepycat.db.*;

class replaceIndex
{
    
    private static String theContainer = "namespaceExampleData.dbxml";
    private static void usage()
    {
         String usageMessage = "\nThis program replaces a DB XML container's index specification with a new\n";
                usageMessage += "specification. You should run exampleLoadContainer before running this example.\n";
                usageMessage += "You are only required to pass this command the path location of the database\n";
                usageMessage += "environment that you specified when you loaded the examples data:\n\n";

                usageMessage += "\t-h <dbenv directory>\n\n";

                usageMessage += "For best results, run addIndex before running this program.\n\n";

                usageMessage += "For example:\n";
                usageMessage += "\tjava com.sleepycat.dbxml.examples.gettingStarted.replaceIndex -h examplesEnvironment\n";

         System.out.println(usageMessage);
         System.exit( -1 );
    }

    //Method used to replace an index with a new index type
    private static void replaceIndex( XmlContainer container, String URI, String nodeName,
                                      String indexType, DbTxn txn ) throws Throwable
    {
       System.out.println("Replacing index specification " + indexType + " for node " + nodeName);

       //Retrieve the index specification from the container
       XmlIndexSpecification idxSpec = container.getIndexSpecification(txn);

       //See what indexes exist on the container
       int count = 0;
       System.out.println("Before index replacement.");
       XmlIndexDeclaration idxDecl = null;
       while((idxDecl = (idxSpec.next())) != null) {
           System.out.println("\tFor node '" + idxDecl.name + "', found index: '" + idxDecl.index + "'.");
           count ++;
       }

       System.out.println(count + " indexes found.");

       //Replace the container's index specification with a new specification
       idxSpec.replaceIndex(URI, nodeName, indexType);

       //Set the specification back to the container
       container.setIndexSpecification(txn, idxSpec);

       //Look at the indexes again to make sure our replacement took.
       count = 0;
       idxSpec.reset();
       System.out.println("After index replacement.");
       while((idxDecl = (idxSpec.next())) != null) {
           System.out.println("\tFor node '" + idxDecl.name + "', found index: '" + idxDecl.index + "'.");
           count ++;
       }

       System.out.println(count + " indexes found.");
    }


    public static void main(String args[]) throws Throwable
    {

       File path2DbEnv = null;

       for(int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
               switch(args[i].charAt(1)) {
                    case 'h':
                         path2DbEnv = new File(args[++i]);
                         break;
                    default:
                    usage();
               }
            } 
       }


       if (path2DbEnv == null || ! path2DbEnv.isDirectory()) {
            usage();
       }


       myDbEnv theDBEnv = null;
       myXmlContainer openedContainer = null;
       DbTxn txn = null;
       try
       {
            //Open a database environment
            theDBEnv = new myDbEnv(path2DbEnv);
            //Open a container in that environment
            openedContainer = new myXmlContainer(theContainer, theDBEnv);

            //Get a transaction
            txn = theDBEnv.getDbEnv().txnBegin(null, 0);

            //Replace the index on the "product" node.
            replaceIndex(openedContainer.getContainer(), "", "product",
                  "node-attribute-substring-string node-element-equality-string",
                  txn);
            //Commit the index replacement
            txn.commit(0);

       } catch (Exception e) {

           System.err.println("Error replacing index for container " + theContainer);
           System.err.println("   Message: " + e.getMessage());
           //In the event of an error, we abort the operation
           // The database is left in the same state as it was in before
           // we started this operation.
           if ( txn != null ) {
              txn.abort();
           }
           throw e;

       } finally {
           if (openedContainer != null) {
              openedContainer.cleanup();
           }

           if (theDBEnv != null) {
              theDBEnv.cleanup();
           }
       }
    } //end main
}
