#include "dbxml/DbXml.hpp"
#include "db_cxx.h"

using namespace DbXml;
//some exception handling omitted for clarity

int main(void)
{
    //Create and open a database environment. This is a very simple example.
    //See myDbEnv.hpp for a more robust example.
    DbEnv env(0);

    //The path the directory where you want to place the environment
    // must exist!!
    std::string environmentPath = "/path/to/environment/directory";

    //Note that DbEnv::open() requires a null-terminated string for 
    // the environment path string.
    env.open(environmentPath.c_str(),DB_CREATE|DB_INIT_MPOOL, 0);


    //multiple containers can be opened in the same
    //database environment
    XmlContainer container1(&env, "myContainer1");
    container1.open( 0, DB_CREATE, 0 );

    XmlContainer container2(&env, "myContainer2");
    container2.open( 0, DB_CREATE, 0 );
    
    XmlContainer container3(&env, "myContainer3");
    container3.open( 0, DB_CREATE, 0 );

    // do work here //

    //close the containers
    container1.close();
    container2.close();
    container3.close();

    //close the environment
    env.close(0);

    return 0;
}
    
