/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sleepycat.examples.db.Defrec;
import com.sleepycat.examples.db.Histrec;
import com.sleepycat.examples.db.TpcbException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

class TpcbExample
extends DbEnv {
    public static final int TELLERS_PER_BRANCH = 10;
    public static final int ACCOUNTS_PER_TELLER = 10000;
    public static final int HISTORY_PER_BRANCH = 2592000;
    public static final int ACCOUNTS = 100000;
    public static final int BRANCHES = 10;
    public static final int TELLERS = 100;
    public static final int HISTORY = 259200;
    public static final int HISTORY_LEN = 100;
    public static final int RECLEN = 100;
    public static final int BEGID = 1000000;
    public static final int ACCOUNT = 0;
    public static final int BRANCH = 1;
    public static final int TELLER = 2;
    public static boolean verbose = false;
    public static final String progname = "TpcbExample";
    int accounts;
    int branches;
    int tellers;
    int history;
    static Random rand = new Random();

    public TpcbExample(String home, int accounts, int branches, int tellers, int history, int cachesize, boolean initializing, int flags) throws DbException, FileNotFoundException {
        super(0);
        this.accounts = accounts;
        this.branches = branches;
        this.tellers = tellers;
        this.history = history;
        this.setErrorStream(System.err);
        this.setErrorPrefix(progname);
        this.setCacheSize(cachesize == 0 ? 0x400000L : (long)cachesize, 0);
        if ((flags & Db.DB_TXN_NOSYNC) != 0) {
            this.setFlags(Db.DB_TXN_NOSYNC, true);
        }
        this.setLockDetect(Db.DB_LOCK_DEFAULT);
        int local_flags = (flags &= ~Db.DB_TXN_NOSYNC) | Db.DB_CREATE;
        local_flags = initializing ? (local_flags |= Db.DB_INIT_MPOOL) : (local_flags |= Db.DB_INIT_TXN | Db.DB_INIT_LOCK | Db.DB_INIT_LOG | Db.DB_INIT_MPOOL);
        this.open(home, local_flags, 0);
    }

    public void populate() {
        Db dbp = null;
        int idnum = 1000000;
        int balance = 500000;
        int h_nelem = this.accounts;
        try {
            dbp = new Db((DbEnv)this, 0);
            dbp.setHashNumElements(h_nelem);
            dbp.open(null, "account", null, 2, Db.DB_CREATE | Db.DB_TRUNCATE, 420);
        }
        catch (Exception e1) {
            TpcbExample.errExit(e1, "Open of account file failed");
        }
        int start_anum = idnum;
        this.populateTable(dbp, idnum, balance, h_nelem, "account");
        int end_anum = (idnum += h_nelem) - 1;
        try {
            dbp.close(0);
        }
        catch (DbException e2) {
            TpcbExample.errExit((Exception)((Object)e2), "Account file close failed");
        }
        if (verbose) {
            System.out.println("Populated accounts: " + String.valueOf(start_anum) + " - " + String.valueOf(end_anum));
        }
        h_nelem = this.branches;
        try {
            dbp = new Db((DbEnv)this, 0);
            dbp.setHashNumElements(h_nelem);
            dbp.setHashFillFactor(1);
            dbp.setPageSize(512L);
            dbp.open(null, "branch", null, 2, Db.DB_CREATE | Db.DB_TRUNCATE, 420);
        }
        catch (Exception e3) {
            TpcbExample.errExit(e3, "Branch file create failed");
        }
        int start_bnum = idnum;
        this.populateTable(dbp, idnum, balance, h_nelem, "branch");
        int end_bnum = (idnum += h_nelem) - 1;
        try {
            dbp.close(0);
        }
        catch (DbException dbe4) {
            TpcbExample.errExit((Exception)((Object)dbe4), "Close of branch file failed");
        }
        if (verbose) {
            System.out.println("Populated branches: " + String.valueOf(start_bnum) + " - " + String.valueOf(end_bnum));
        }
        h_nelem = this.tellers;
        try {
            dbp = new Db((DbEnv)this, 0);
            dbp.setHashNumElements(h_nelem);
            dbp.setHashFillFactor(0);
            dbp.setPageSize(512L);
            dbp.open(null, "teller", null, 2, Db.DB_CREATE | Db.DB_TRUNCATE, 420);
        }
        catch (Exception e5) {
            TpcbExample.errExit(e5, "Teller file create failed");
        }
        int start_tnum = idnum;
        this.populateTable(dbp, idnum, balance, h_nelem, "teller");
        int end_tnum = (idnum += h_nelem) - 1;
        try {
            dbp.close(0);
        }
        catch (DbException e6) {
            TpcbExample.errExit((Exception)((Object)e6), "Close of teller file failed");
        }
        if (verbose) {
            System.out.println("Populated tellers: " + String.valueOf(start_tnum) + " - " + String.valueOf(end_tnum));
        }
        try {
            dbp = new Db((DbEnv)this, 0);
            dbp.setRecordLength(100);
            dbp.open(null, "history", null, 3, Db.DB_CREATE | Db.DB_TRUNCATE, 420);
        }
        catch (Exception e7) {
            TpcbExample.errExit(e7, "Create of history file failed");
        }
        this.populateHistory(dbp);
        try {
            dbp.close(0);
        }
        catch (DbException e8) {
            TpcbExample.errExit((Exception)((Object)e8), "Close of history file failed");
        }
    }

    public void populateTable(Db dbp, int start_id, int balance, int nrecs, String msg) {
        Defrec drec = new Defrec();
        Dbt kdbt = new Dbt(drec.data);
        kdbt.setSize(4);
        Dbt ddbt = new Dbt(drec.data);
        ddbt.setSize(drec.data.length);
        try {
            int i = 0;
            while (i < nrecs) {
                kdbt.setRecordNumber(start_id + i);
                drec.set_balance(balance);
                dbp.put(null, kdbt, ddbt, Db.DB_NOOVERWRITE);
                ++i;
            }
        }
        catch (DbException dbe) {
            System.err.println("Failure initializing " + msg + " file: " + dbe.toString());
            System.exit(1);
        }
    }

    public void populateHistory(Db dbp) {
        Histrec hrec = new Histrec();
        hrec.set_amount(10L);
        byte[] arr = new byte[4];
        Dbt kdbt = new Dbt(arr);
        kdbt.setSize(arr.length);
        Dbt ddbt = new Dbt(hrec.data);
        ddbt.setSize(hrec.data.length);
        try {
            int i = 1;
            while (i <= this.history) {
                kdbt.setRecordNumber(i);
                hrec.set_aid(this.random_id(0));
                hrec.set_bid(this.random_id(1));
                hrec.set_tid(this.random_id(2));
                dbp.put(null, kdbt, ddbt, Db.DB_APPEND);
                ++i;
            }
        }
        catch (DbException dbe) {
            TpcbExample.errExit((Exception)((Object)dbe), "Failure initializing history file");
        }
    }

    public int random_int(int lo, int hi) {
        int t = rand.nextInt();
        if (t < 0) {
            t = -t;
        }
        int ret = (int)((double)t / 2.147483648E9 * (double)(hi - lo + 1));
        return ret += lo;
    }

    public int random_id(int type) {
        int min = 1000000;
        int max = 1000000;
        int num = this.accounts;
        switch (type) {
            case 2: {
                min += this.branches;
                num = this.tellers;
            }
            case 1: {
                if (type == 1) {
                    num = this.branches;
                }
                min += this.accounts;
            }
            case 0: {
                max = min + num - 1;
            }
        }
        return this.random_int(min, max);
    }

    static long get_int_in_array(byte[] array, int offset) {
        return (0xFF & array[offset + 0]) << 0 | (0xFF & array[offset + 1]) << 8 | (0xFF & array[offset + 2]) << 16 | (0xFF & array[offset + 3]) << 24;
    }

    static void set_int_in_array(byte[] array, int offset, long value) {
        array[offset + 0] = (byte)(value >> 0 & 0xFFL);
        array[offset + 1] = (byte)(value >> 8 & 0xFFL);
        array[offset + 2] = (byte)(value >> 16 & 0xFFL);
        array[offset + 3] = (byte)(value >> 24 & 0xFFL);
    }

    static String showRounded(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 5).toString();
    }

    public void run(int ntxns, int threads) {
        TxnThread[] txnList = new TxnThread[threads];
        int i = 0;
        while (i < threads) {
            txnList[i] = new TxnThread("Thread " + String.valueOf(i), ntxns);
            ++i;
        }
        long starttime = new Date().getTime();
        int i2 = 0;
        while (i2 < threads) {
            txnList[i2].start();
            ++i2;
        }
        int i3 = 0;
        while (i3 < threads) {
            try {
                txnList[i3].join();
            }
            catch (Exception e1) {
                TpcbExample.errExit(e1, "join failed");
            }
            ++i3;
        }
        long curtime = new Date().getTime();
        int failed = 0;
        int txns = 0;
        int i4 = 0;
        while (i4 < threads) {
            txns += txnList[i4].txns;
            failed += txnList[i4].failed;
            ++i4;
        }
        double gtps = (double)(txns - failed) / ((double)(curtime - starttime) / 1000.0);
        System.out.print("\nTotal: " + String.valueOf(txns) + " txns " + String.valueOf(failed) + " failed ");
        System.out.println(TpcbExample.showRounded(gtps, 2) + " TPS");
    }

    private static void usage() {
        System.err.println("usage: TpcbExample [-fiv] [-a accounts] [-b branches]\n                   [-c cachesize] [-h home] [-n transactions]\n                   [-T threads] [-S seed] [-s history] [-t tellers]");
        System.exit(1);
    }

    private static void invarg(String str) {
        System.err.println("TpcbExample: invalid argument: " + str);
        System.exit(1);
    }

    public static void errExit(Exception err, String s) {
        System.err.print("TpcbExample: ");
        if (s != null) {
            System.err.print(s + ": ");
        }
        System.err.println(err.toString());
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException {
        String home = "TESTDIR";
        int accounts = 100000;
        int branches = 10;
        int tellers = 100;
        int history = 259200;
        int threads = 1;
        int mpool = 0;
        int ntxns = 0;
        boolean iflag = false;
        boolean txn_no_sync = false;
        long seed = new GregorianCalendar().get(13);
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-a")) {
                if ((accounts = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-b")) {
                if ((branches = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-c")) {
                if ((mpool = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-f")) {
                txn_no_sync = true;
            } else if (argv[i].equals("-h")) {
                home = argv[++i];
            } else if (argv[i].equals("-i")) {
                iflag = true;
            } else if (argv[i].equals("-n")) {
                if ((ntxns = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-S")) {
                if ((seed = Long.parseLong(argv[++i])) <= 0L) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-s")) {
                if ((history = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-T")) {
                if ((threads = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-t")) {
                if ((tellers = Integer.parseInt(argv[++i])) <= 0) {
                    TpcbExample.invarg(argv[i]);
                }
            } else if (argv[i].equals("-v")) {
                verbose = true;
            } else {
                TpcbExample.usage();
            }
            ++i;
        }
        rand.setSeed((int)seed);
        TpcbExample app = null;
        try {
            app = new TpcbExample(home, accounts, branches, tellers, history, mpool, iflag, txn_no_sync ? Db.DB_TXN_NOSYNC : 0);
        }
        catch (Exception e1) {
            TpcbExample.errExit(e1, "initializing environment failed");
        }
        if (verbose) {
            System.out.println((long)accounts + " Accounts, " + String.valueOf(branches) + " Branches, " + String.valueOf(tellers) + " Tellers, " + String.valueOf(history) + " History");
        }
        if (iflag) {
            if (ntxns != 0) {
                TpcbExample.usage();
            }
            app.populate();
        } else {
            if (ntxns == 0) {
                TpcbExample.usage();
            }
            app.run(ntxns, threads);
        }
        try {
            app.close(0);
        }
        catch (DbException dbe2) {
            TpcbExample.errExit((Exception)((Object)dbe2), "appexit failed");
        }
        System.exit(0);
    }

    class TxnThread
    extends Thread {
        private int ntxns;
        public int txns;
        public int failed;
        private Db adb;
        private Db bdb;
        private Db hdb;
        private Db tdb;

        public TxnThread(String name, int ntxns) {
            super(name);
            this.ntxns = ntxns;
        }

        public void run() {
            long starttime;
            try {
                this.adb = new Db((DbEnv)TpcbExample.this, 0);
                this.adb.open(null, "account", null, 5, Db.DB_AUTO_COMMIT, 0);
                this.bdb = new Db((DbEnv)TpcbExample.this, 0);
                this.bdb.open(null, "branch", null, 5, Db.DB_AUTO_COMMIT, 0);
                this.tdb = new Db((DbEnv)TpcbExample.this, 0);
                this.tdb.open(null, "teller", null, 5, Db.DB_AUTO_COMMIT, 0);
                this.hdb = new Db((DbEnv)TpcbExample.this, 0);
                this.hdb.open(null, "history", null, 5, Db.DB_AUTO_COMMIT, 0);
            }
            catch (DbException dbe) {
                TpcbExample.errExit((Exception)((Object)dbe), "Open of db files failed");
            }
            catch (FileNotFoundException fnfe) {
                TpcbExample.errExit(fnfe, "Open of db files failed, missing file");
            }
            int ifailed = 0;
            long lasttime = starttime = new Date().getTime();
            int n = this.ntxns;
            while (n-- > 0) {
                ++this.txns;
                int ret = this.txn();
                if (ret != 0) {
                    ++this.failed;
                    ++ifailed;
                }
                if (n % 5000 != 0) continue;
                long curtime = new Date().getTime();
                double gtps = (double)(this.txns - this.failed) / ((double)(curtime - starttime) / 1000.0);
                double itps = (double)(5000 - ifailed) / ((double)(curtime - lasttime) / 1000.0);
                System.out.print(this.getName() + ": " + String.valueOf(this.txns) + " txns " + String.valueOf(this.failed) + " failed ");
                System.out.println(TpcbExample.showRounded(gtps, 2) + " TPS (gross) " + TpcbExample.showRounded(itps, 2) + " TPS (interval)");
                lasttime = curtime;
                ifailed = 0;
            }
            try {
                this.adb.close(0);
                this.bdb.close(0);
                this.tdb.close(0);
                this.hdb.close(0);
            }
            catch (DbException dbe2) {
                TpcbExample.errExit((Exception)((Object)dbe2), "Close of db files failed");
            }
            System.out.println(this.getName() + ": " + (long)this.txns + " transactions begun " + String.valueOf(this.failed) + " failed");
        }

        int txn() {
            Dbc acurs = null;
            Dbc bcurs = null;
            Dbc hcurs = null;
            Dbc tcurs = null;
            DbTxn t = null;
            Defrec rec = new Defrec();
            Histrec hrec = new Histrec();
            Dbt d_dbt = new Dbt();
            Dbt d_histdbt = new Dbt();
            Dbt k_dbt = new Dbt();
            Dbt k_histdbt = new Dbt();
            int account = TpcbExample.this.random_id(0);
            int branch = TpcbExample.this.random_id(1);
            int teller = TpcbExample.this.random_id(2);
            byte[] hist_key = new byte[4];
            k_histdbt.setData(hist_key);
            k_histdbt.setSize(4);
            byte[] key_bytes = new byte[4];
            k_dbt.setData(key_bytes);
            k_dbt.setSize(4);
            d_dbt.setFlags(Db.DB_DBT_USERMEM);
            d_dbt.setData(rec.data);
            d_dbt.setUserBufferLength(rec.length());
            hrec.set_aid(account);
            hrec.set_bid(branch);
            hrec.set_tid(teller);
            hrec.set_amount(10L);
            d_histdbt.setFlags(Db.DB_DBT_PARTIAL);
            try {
                t = TpcbExample.this.txnBegin(null, 0);
                acurs = this.adb.cursor(t, 0);
                bcurs = this.bdb.cursor(t, 0);
                tcurs = this.tdb.cursor(t, 0);
                hcurs = this.hdb.cursor(t, 0);
                k_dbt.setRecordNumber(account);
                if (acurs.get(k_dbt, d_dbt, Db.DB_SET) != 0) {
                    throw new TpcbException("acurs get failed");
                }
                rec.set_balance(rec.get_balance() + 10L);
                acurs.put(k_dbt, d_dbt, Db.DB_CURRENT);
                k_dbt.setRecordNumber(branch);
                int ret = bcurs.get(k_dbt, d_dbt, Db.DB_SET);
                if (ret != 0) {
                    throw new TpcbException("bcurs get failed");
                }
                rec.set_balance(rec.get_balance() + 10L);
                bcurs.put(k_dbt, d_dbt, Db.DB_CURRENT);
                k_dbt.setRecordNumber(teller);
                if (tcurs.get(k_dbt, d_dbt, Db.DB_SET) != 0) {
                    throw new TpcbException("ccurs get failed");
                }
                rec.set_balance(rec.get_balance() + 10L);
                tcurs.put(k_dbt, d_dbt, Db.DB_CURRENT);
                d_histdbt.setFlags(0);
                d_histdbt.setData(hrec.data);
                d_histdbt.setUserBufferLength(hrec.length());
                if (this.hdb.put(t, k_histdbt, d_histdbt, Db.DB_APPEND) != 0) {
                    throw new DbException("put failed");
                }
                acurs.close();
                acurs = null;
                bcurs.close();
                bcurs = null;
                tcurs.close();
                tcurs = null;
                hcurs.close();
                hcurs = null;
                DbTxn tmptxn = t;
                t = null;
                tmptxn.commit(0);
                return 0;
            }
            catch (Exception e) {
                try {
                    if (acurs != null) {
                        acurs.close();
                    }
                    if (bcurs != null) {
                        bcurs.close();
                    }
                    if (tcurs != null) {
                        tcurs.close();
                    }
                    if (hcurs != null) {
                        hcurs.close();
                    }
                    if (t != null) {
                        t.abort();
                    }
                }
                catch (DbException dbe) {
                    // empty catch block
                }
                if (verbose) {
                    System.out.println("Transaction A=" + String.valueOf(account) + " B=" + String.valueOf(branch) + " T=" + String.valueOf(teller) + " failed");
                    System.out.println("Reason: " + e.toString());
                }
                return -1;
            }
        }
    }
}

