/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbLock;
import com.sleepycat.db.DbLockNotGrantedException;
import com.sleepycat.db.Dbt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

class LockExample
extends DbEnv {
    private static final String progname = "LockExample";
    private static final String LOCK_HOME = "TESTDIR";

    public LockExample(String home, int maxlocks, boolean do_unlink) throws DbException, FileNotFoundException {
        super(0);
        if (do_unlink) {
            this.remove(home, Db.DB_FORCE);
        } else {
            this.setErrorStream(System.err);
            this.setErrorPrefix(progname);
            if (maxlocks != 0) {
                this.setLockMaxLocks(maxlocks);
            }
            this.open(home, Db.DB_CREATE | Db.DB_INIT_LOCK, 0);
        }
    }

    public static String askForLine(InputStreamReader reader, PrintStream out, String prompt) {
        String result = "";
        while (result != null && result.length() == 0) {
            out.print(prompt);
            out.flush();
            result = LockExample.getLine(reader);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLine(InputStreamReader reader) {
        int c;
        StringBuffer b = new StringBuffer();
        try {
            while ((c = reader.read()) != -1 && c != 10) {
                void var2_2;
                if (var2_2 == 13) continue;
                b.append((char)var2_2);
            }
        }
        catch (IOException ioe) {
            c = -1;
        }
        if (c == -1 && b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    public void run() throws DbException {
        String opbuf;
        int len = 0;
        boolean did_get = false;
        int lockid = 0;
        InputStreamReader in = new InputStreamReader(System.in);
        Vector<DbLock> locks = new Vector<DbLock>();
        int locker = this.lockId();
        long held = 0L;
        while ((opbuf = LockExample.askForLine(in, System.out, "Operation get/release [get]> ")) != null) {
            try {
                String objbuf;
                if (opbuf.equals("get")) {
                    String lockbuf;
                    objbuf = LockExample.askForLine(in, System.out, "input object (text string) to lock> ");
                    if (objbuf == null) break;
                    while ((lockbuf = LockExample.askForLine(in, System.out, "lock type read/write [read]> ")) != null && (len = lockbuf.length()) >= 1 && !lockbuf.equals("read") && !lockbuf.equals("write")) {
                    }
                    int lock_type = len <= 1 || lockbuf.equals("read") ? Db.DB_LOCK_READ : Db.DB_LOCK_WRITE;
                    Dbt dbt = new Dbt(objbuf.getBytes());
                    did_get = true;
                    DbLock lock = this.lockGet(locker, Db.DB_LOCK_NOWAIT, dbt, lock_type);
                    lockid = locks.size();
                    locks.addElement(lock);
                } else {
                    objbuf = LockExample.askForLine(in, System.out, "input lock to release> ");
                    if (objbuf == null) break;
                    lockid = Integer.parseInt(objbuf, 16);
                    if (lockid < 0 || lockid >= locks.size()) {
                        System.out.println("Lock #" + lockid + " out of range");
                        continue;
                    }
                    did_get = false;
                    DbLock lock = (DbLock)locks.elementAt(lockid);
                    this.lockPut(lock);
                }
                System.out.println("Lock #" + lockid + " " + (did_get ? "granted" : "released"));
                held += did_get ? 1L : -1L;
            }
            catch (DbLockNotGrantedException lnge) {
                System.err.println("Lock not granted");
            }
            catch (DbDeadlockException de) {
                System.err.println("LockExample: lock_" + (did_get ? "get" : "put") + ": returned DEADLOCK");
            }
            catch (DbException dbe) {
                System.err.println("LockExample: lock_get: " + dbe.toString());
            }
        }
        System.out.println();
        System.out.println("Closing lock region " + String.valueOf(held) + " locks held");
    }

    private static void usage() {
        System.err.println("usage: LockExample [-u] [-h home] [-m maxlocks]");
        System.exit(1);
    }

    public static void main(String[] argv) {
        String home = LOCK_HOME;
        boolean do_unlink = false;
        int maxlocks = 0;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-h")) {
                if (++i >= argv.length) {
                    LockExample.usage();
                }
                home = argv[i];
            } else if (argv[i].equals("-m")) {
                if (++i >= argv.length) {
                    LockExample.usage();
                }
                try {
                    maxlocks = Integer.parseInt(argv[i]);
                }
                catch (NumberFormatException nfe) {
                    LockExample.usage();
                }
            } else if (argv[i].equals("-u")) {
                do_unlink = true;
            } else {
                LockExample.usage();
            }
            ++i;
        }
        try {
            if (do_unlink) {
                LockExample tmp = new LockExample(home, maxlocks, do_unlink);
            }
            LockExample app = new LockExample(home, maxlocks, do_unlink);
            app.run();
            app.close(0);
        }
        catch (DbException dbe) {
            System.err.println("LockExample: " + dbe.toString());
        }
        catch (Throwable t) {
            System.err.println("LockExample: " + t.toString());
        }
        System.out.println("LockExample completed");
    }
}

