/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public class EnvExample {
    private static final String progname = "EnvExample";
    private static final String DATABASE_HOME = "/tmp/database";

    private static void db_application() throws DbException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void db_setup(String home, String data_dir, OutputStream errs) throws DbException, FileNotFoundException {
        DbEnv dbenv = new DbEnv(0);
        dbenv.setErrorStream(errs);
        dbenv.setErrorPrefix(progname);
        dbenv.setCacheSize(65536L, 0);
        dbenv.setDataDir(data_dir);
        dbenv.open(DATABASE_HOME, Db.DB_CREATE | Db.DB_INIT_LOCK | Db.DB_INIT_LOG | Db.DB_INIT_MPOOL | Db.DB_INIT_TXN, 0);
        try {
            EnvExample.db_application();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dbenv.close(0);
            throw throwable;
        }
        dbenv.close(0);
    }

    private static void db_teardown(String home, String data_dir, OutputStream errs) throws DbException, FileNotFoundException {
        DbEnv dbenv = new DbEnv(0);
        dbenv.setErrorStream(errs);
        dbenv.setErrorPrefix(progname);
        dbenv.setDataDir(data_dir);
        dbenv.remove(home, 0);
    }

    public static void main(String[] args) {
        String home = DATABASE_HOME;
        String config = "/database/files";
        try {
            System.out.println("Setup env");
            EnvExample.db_setup(home, config, System.err);
            System.out.println("Teardown env");
            EnvExample.db_teardown(home, config, System.err);
        }
        catch (DbException dbe) {
            System.err.println("EnvExample: environment open: " + dbe.toString());
            System.exit(1);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("EnvExample: unexpected open environment error  " + fnfe);
            System.exit(1);
        }
    }
}

