/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbMultipleKeyDataIterator;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

class BulkAccessExample {
    private static final String FileName = "access.db";

    public static void main(String[] argv) {
        try {
            BulkAccessExample app = new BulkAccessExample();
            app.run();
        }
        catch (DbException dbe) {
            System.err.println("BulkAccessExample: " + dbe.toString());
            System.exit(1);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("BulkAccessExample: " + fnfe.toString());
            System.exit(1);
        }
        System.exit(0);
    }

    public static String askForLine(InputStreamReader reader, PrintStream out, String prompt) {
        String result = "";
        while (result != null && result.length() == 0) {
            out.print(prompt);
            out.flush();
            result = BulkAccessExample.getLine(reader);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLine(InputStreamReader reader) {
        int c;
        StringBuffer b = new StringBuffer();
        try {
            while ((c = reader.read()) != -1 && c != 10) {
                void var2_2;
                if (var2_2 == 13) continue;
                b.append((char)var2_2);
            }
        }
        catch (IOException ioe) {
            c = -1;
        }
        if (c == -1 && b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    public void run() throws DbException, FileNotFoundException {
        String line;
        new File(FileName).delete();
        Db table = new Db(null, 0);
        table.setErrorStream((OutputStream)System.err);
        table.setErrorPrefix("BulkAccessExample");
        table.open(null, FileName, null, 1, Db.DB_CREATE, 420);
        InputStreamReader reader = new InputStreamReader(System.in);
        while ((line = BulkAccessExample.askForLine(reader, System.out, "input> ")) != null) {
            String reversed = new StringBuffer(line).reverse().toString();
            StringDbt key = new StringDbt(line);
            StringDbt data = new StringDbt(reversed);
            try {
                int err = table.put(null, (Dbt)key, (Dbt)data, Db.DB_NOOVERWRITE);
                if (err == -30996) {
                    System.out.println("Key " + line + " already exists.");
                }
            }
            catch (DbException dbe) {
                System.out.println(dbe.toString());
            }
            System.out.println("");
        }
        Dbc dbc = table.cursor(null, 0);
        Dbt foo = new Dbt();
        foo.setFlags(Db.DB_DBT_MALLOC);
        Dbt bulk_data = new Dbt();
        bulk_data.setFlags(Db.DB_DBT_USERMEM);
        bulk_data.setData(new byte[1000000]);
        bulk_data.setUserBufferLength(1000000);
        while (dbc.get(foo, bulk_data, Db.DB_NEXT | Db.DB_MULTIPLE_KEY) == 0) {
            DbMultipleKeyDataIterator iterator = new DbMultipleKeyDataIterator(bulk_data);
            StringDbt key = new StringDbt();
            StringDbt data = new StringDbt();
            while (iterator.next((Dbt)key, (Dbt)data)) {
                System.out.println(key.getString() + " : " + data.getString());
            }
        }
        dbc.close();
        table.close(0);
    }

    static class StringDbt
    extends Dbt {
        StringDbt() {
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        StringDbt(String value) {
            this.setString(value);
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        void setString(String value) {
            byte[] data = value.getBytes();
            this.setData(data);
            this.setSize(data.length);
        }

        String getString() {
            return new String(this.getData(), this.getOffset(), this.getSize());
        }
    }
}

