/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbBtreeStat;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class BtRecExample {
    static final String progname = "BtRecExample";
    static final String database = "access.db";
    static final String wordlist = "../test/wordlist";
    private Dbc dbcp;
    private Db dbp;

    BtRecExample(BufferedReader reader) throws DbException, IOException, FileNotFoundException {
        File f = new File(database);
        f.delete();
        this.dbp = new Db(null, 0);
        this.dbp.setErrorStream((OutputStream)System.err);
        this.dbp.setErrorPrefix(progname);
        this.dbp.setPageSize(1024L);
        this.dbp.setFlags(Db.DB_RECNUM);
        this.dbp.open(null, database, null, 1, Db.DB_CREATE, 436);
        int cnt = 1;
        while (cnt <= 1000) {
            StringBuffer rbuf;
            StringDbt data;
            String numstr = String.valueOf(cnt);
            while (numstr.length() < 4) {
                numstr = "0" + numstr;
            }
            String buf = numstr + '_' + reader.readLine();
            StringDbt key = new StringDbt(buf);
            int ret = this.dbp.put(null, (Dbt)key, (Dbt)(data = new StringDbt((rbuf = new StringBuffer(buf).reverse()).toString())), Db.DB_NOOVERWRITE);
            if (ret != 0 && ret != -30996) {
                throw new DbException("Db.put failed" + ret);
            }
            ++cnt;
        }
    }

    void run() throws DbException {
        String line;
        this.dbcp = this.dbp.cursor(null, 0);
        InputStreamReader reader = new InputStreamReader(System.in);
        while ((line = BtRecExample.askForLine(reader, System.out, "recno #> ")) != null) {
            int recno;
            try {
                recno = Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Bad record number: " + nfe);
                continue;
            }
            RecnoStringDbt key = new RecnoStringDbt(recno, 100);
            RecnoStringDbt data = new RecnoStringDbt(100);
            int ret = this.dbcp.get((Dbt)key, (Dbt)data, Db.DB_SET_RECNO);
            if (ret != 0) {
                throw new DbException("Dbc.get failed", ret);
            }
            this.show("k/d\t", key, data);
            ret = this.dbcp.get((Dbt)key, (Dbt)data, Db.DB_NEXT);
            if (ret != 0) {
                throw new DbException("Dbc.get failed", ret);
            }
            this.show("next\t", key, data);
            RecnoStringDbt datano = new RecnoStringDbt(100);
            ret = this.dbcp.get((Dbt)key, (Dbt)datano, Db.DB_GET_RECNO);
            if (ret != 0) {
                if (ret == -30990 || ret == -30997) continue;
                throw new DbException("Dbc.get failed", ret);
            }
            recno = datano.getRecno();
            System.out.println("retrieved recno: " + recno);
        }
        this.dbcp.close();
        this.dbcp = null;
    }

    void stats() throws DbException {
        DbBtreeStat statp = (DbBtreeStat)this.dbp.stat(0);
        System.out.println("BtRecExample: database contains " + statp.bt_ndata + " records");
    }

    void show(String msg, RecnoStringDbt key, RecnoStringDbt data) throws DbException {
        System.out.println(msg + key.getString() + ": " + data.getString());
    }

    public void shutdown() throws DbException {
        if (this.dbcp != null) {
            this.dbcp.close();
            this.dbcp = null;
        }
        if (this.dbp != null) {
            this.dbp.close(0);
            this.dbp = null;
        }
    }

    public static void main(String[] argv) {
        try {
            FileReader freader = new FileReader(wordlist);
            BtRecExample app = new BtRecExample(new BufferedReader(freader));
            freader.close();
            freader = null;
            app.stats();
            app.run();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("BtRecExample: unexpected open error " + fnfe);
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println("BtRecExample: open ../test/wordlist: " + ioe);
            System.exit(1);
        }
        catch (DbException dbe) {
            System.err.println("Exception: " + (Object)((Object)dbe));
            System.exit(dbe.getErrno());
        }
        System.exit(0);
    }

    public static String askForLine(InputStreamReader reader, PrintStream out, String prompt) {
        String result = "";
        while (result != null && result.length() == 0) {
            out.print(prompt);
            out.flush();
            result = BtRecExample.getLine(reader);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLine(InputStreamReader reader) {
        int c;
        StringBuffer b = new StringBuffer();
        try {
            while ((c = reader.read()) != -1 && c != 10) {
                void var2_2;
                if (var2_2 == 13) continue;
                b.append((char)var2_2);
            }
        }
        catch (IOException ioe) {
            c = -1;
        }
        if (c == -1 && b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    static class RecnoStringDbt
    extends Dbt {
        byte[] arr;

        RecnoStringDbt(int maxsize) {
            this(0, maxsize);
        }

        RecnoStringDbt(int value, int maxsize) {
            this.setFlags(Db.DB_DBT_USERMEM);
            this.arr = new byte[maxsize];
            this.setData(this.arr);
            this.setUserBufferLength(maxsize);
            this.setRecno(value);
        }

        RecnoStringDbt(String value, int maxsize) {
            this.setFlags(Db.DB_DBT_USERMEM);
            this.arr = new byte[maxsize];
            this.setData(this.arr);
            this.setUserBufferLength(maxsize);
            this.setString(value);
        }

        void setRecno(int value) {
            this.setRecordNumber(value);
            this.setSize(this.arr.length);
        }

        void setString(String value) {
            byte[] data = value.getBytes();
            this.setData(data);
            this.setSize(data.length);
        }

        int getRecno() {
            return this.getRecordNumber();
        }

        String getString() {
            return new String(this.getData(), 0, this.getSize());
        }
    }

    static class StringDbt
    extends Dbt {
        StringDbt(byte[] arr) {
            this.setFlags(Db.DB_DBT_USERMEM);
            this.setData(arr);
            this.setSize(arr.length);
        }

        StringDbt() {
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        StringDbt(String value) {
            this.setString(value);
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        void setString(String value) {
            byte[] data = value.getBytes();
            this.setData(data);
            this.setSize(data.length);
            this.setUserBufferLength(data.length);
        }

        String getString() {
            return new String(this.getData(), 0, this.getSize());
        }
    }
}

