/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

class AccessExample {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;

    public static void usage() {
        System.out.println("usage: java com.sleepycat.examples.db.AccessExample [-r] [database]\n");
        System.exit(1);
    }

    public static void main(String[] argv) {
        boolean removeExistingDatabase = false;
        String databaseName = "access.db";
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-r")) {
                removeExistingDatabase = true;
            } else if (argv[i].equals("-?")) {
                AccessExample.usage();
            } else if (argv[i].startsWith("-")) {
                AccessExample.usage();
            } else {
                if (argv.length - i != 1) {
                    AccessExample.usage();
                }
                databaseName = argv[i];
                break;
            }
            ++i;
        }
        try {
            AccessExample app = new AccessExample();
            app.run(removeExistingDatabase, databaseName);
        }
        catch (DbException dbe) {
            System.err.println("AccessExample: " + dbe.toString());
            System.exit(1);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("AccessExample: " + fnfe.toString());
            System.exit(1);
        }
        System.exit(0);
    }

    public static String askForLine(InputStreamReader reader, PrintStream out, String prompt) {
        String result = "";
        while (result != null && result.length() == 0) {
            out.print(prompt);
            out.flush();
            result = AccessExample.getLine(reader);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLine(InputStreamReader reader) {
        int c;
        StringBuffer b = new StringBuffer();
        try {
            while ((c = reader.read()) != -1 && c != 10) {
                void var2_2;
                if (var2_2 == 13) continue;
                b.append((char)var2_2);
            }
        }
        catch (IOException ioe) {
            c = -1;
        }
        if (c == -1 && b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    public void run(boolean removeExistingDatabase, String databaseName) throws DbException, FileNotFoundException {
        String line;
        if (removeExistingDatabase) {
            new File(databaseName).delete();
        }
        Db table = new Db(null, 0);
        table.setErrorStream((OutputStream)System.err);
        table.setErrorPrefix("AccessExample");
        table.open(null, databaseName, null, 1, Db.DB_CREATE, 420);
        InputStreamReader reader = new InputStreamReader(System.in);
        while ((line = AccessExample.askForLine(reader, System.out, "input> ")) != null) {
            String reversed = new StringBuffer(line).reverse().toString();
            StringDbt key = new StringDbt(line);
            StringDbt data = new StringDbt(reversed);
            try {
                int err = 0;
                err = table.put(null, (Dbt)key, (Dbt)data, Db.DB_NOOVERWRITE);
                if (err != -30996) continue;
                System.out.println("Key " + line + " already exists.");
            }
            catch (DbException dbe) {
                System.out.println(dbe.toString());
            }
        }
        Dbc iterator = table.cursor(null, 0);
        StringDbt key = new StringDbt();
        StringDbt data = new StringDbt();
        while (iterator.get((Dbt)key, (Dbt)data, Db.DB_NEXT) == 0) {
            System.out.println(key.getString() + " : " + data.getString());
        }
        iterator.close();
        table.close(0);
    }

    static class StringDbt
    extends Dbt {
        StringDbt() {
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        StringDbt(String value) {
            this.setString(value);
            this.setFlags(Db.DB_DBT_MALLOC);
        }

        void setString(String value) {
            byte[] data = value.getBytes();
            this.setData(data);
            this.setSize(data.length);
        }

        String getString() {
            return new String(this.getData(), 0, this.getSize());
        }
    }
}

