/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.tuple;

import com.sleepycat.bdb.TransactionRunner;
import com.sleepycat.bdb.TransactionWorker;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredSortedValueSet;
import com.sleepycat.db.DbException;
import com.sleepycat.examples.bdb.shipment.tuple.Part;
import com.sleepycat.examples.bdb.shipment.tuple.PartKey;
import com.sleepycat.examples.bdb.shipment.tuple.SampleDatabase;
import com.sleepycat.examples.bdb.shipment.tuple.SampleViews;
import com.sleepycat.examples.bdb.shipment.tuple.Shipment;
import com.sleepycat.examples.bdb.shipment.tuple.Supplier;
import com.sleepycat.examples.bdb.shipment.tuple.SupplierKey;
import com.sleepycat.examples.bdb.shipment.tuple.Weight;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class Sample {
    private SampleDatabase db;
    private SampleViews views;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$tuple$Sample;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("\nRunning sample: " + (class$com$sleepycat$examples$bdb$shipment$tuple$Sample == null ? (class$com$sleepycat$examples$bdb$shipment$tuple$Sample = Sample.class$("com.sleepycat.examples.bdb.shipment.tuple.Sample")) : class$com$sleepycat$examples$bdb$shipment$tuple$Sample));
        boolean runRecovery = true;
        String homeDir = "./tmp";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (args[i].equals("-h") && i < args.length - 1) {
                homeDir = args[++i];
            } else if (args[i].equals("-multiprocess")) {
                runRecovery = false;
            } else {
                System.err.println("Usage:\n java " + (class$com$sleepycat$examples$bdb$shipment$tuple$Sample == null ? Sample.class$("com.sleepycat.examples.bdb.shipment.tuple.Sample") : class$com$sleepycat$examples$bdb$shipment$tuple$Sample).getName() + "\n  [-h <home-directory>] [-multiprocess]");
                System.exit(2);
            }
            ++i;
        }
        Sample sample = null;
        try {
            sample = new Sample(homeDir, runRecovery);
            sample.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sample != null) {
                try {
                    sample.close();
                }
                catch (Exception e) {
                    System.err.println("Exception during database close:");
                    e.printStackTrace();
                }
            }
        }
    }

    private Sample(String homeDir, boolean runRecovery) throws DbException, FileNotFoundException {
        this.db = new SampleDatabase(homeDir, runRecovery);
        this.views = new SampleViews(this.db);
    }

    private void close() throws DbException, IOException {
        this.db.close();
    }

    private void run() throws Exception {
        TransactionRunner runner = new TransactionRunner(this.db.getEnvironment());
        runner.run((TransactionWorker)new PopulateDatabase());
        runner.run((TransactionWorker)new PrintDatabase());
    }

    private void addParts() {
        StoredSortedValueSet parts = this.views.getPartSet();
        if (parts.isEmpty()) {
            System.out.println("Adding Parts");
            parts.add(new Part("P1", "Nut", "Red", new Weight(12.0, "grams"), "London"));
            parts.add(new Part("P2", "Bolt", "Green", new Weight(17.0, "grams"), "Paris"));
            parts.add(new Part("P3", "Screw", "Blue", new Weight(17.0, "grams"), "Rome"));
            parts.add(new Part("P4", "Screw", "Red", new Weight(14.0, "grams"), "London"));
            parts.add(new Part("P5", "Cam", "Blue", new Weight(12.0, "grams"), "Paris"));
            parts.add(new Part("P6", "Cog", "Red", new Weight(19.0, "grams"), "London"));
        }
    }

    private void addSuppliers() {
        StoredSortedValueSet suppliers = this.views.getSupplierSet();
        if (suppliers.isEmpty()) {
            System.out.println("Adding Suppliers");
            suppliers.add(new Supplier("S1", "Smith", 20, "London"));
            suppliers.add(new Supplier("S2", "Jones", 10, "Paris"));
            suppliers.add(new Supplier("S3", "Blake", 30, "Paris"));
            suppliers.add(new Supplier("S4", "Clark", 20, "London"));
            suppliers.add(new Supplier("S5", "Adams", 30, "Athens"));
        }
    }

    private void addShipments() {
        StoredSortedValueSet shipments = this.views.getShipmentSet();
        if (shipments.isEmpty()) {
            System.out.println("Adding Shipments");
            shipments.add(new Shipment("P1", "S1", 300));
            shipments.add(new Shipment("P2", "S1", 200));
            shipments.add(new Shipment("P3", "S1", 400));
            shipments.add(new Shipment("P4", "S1", 200));
            shipments.add(new Shipment("P5", "S1", 100));
            shipments.add(new Shipment("P6", "S1", 100));
            shipments.add(new Shipment("P1", "S2", 300));
            shipments.add(new Shipment("P2", "S2", 400));
            shipments.add(new Shipment("P2", "S3", 200));
            shipments.add(new Shipment("P2", "S4", 200));
            shipments.add(new Shipment("P4", "S4", 300));
            shipments.add(new Shipment("P5", "S4", 400));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printValues(String label, Iterator iterator) {
        System.out.println("\n--- " + label + " ---");
        try {
            while (iterator.hasNext()) {
                System.out.println(iterator.next().toString());
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StoredIterator.close((Iterator)iterator);
            throw throwable;
        }
        StoredIterator.close((Iterator)iterator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrintDatabase
    implements TransactionWorker {
        private PrintDatabase() {
        }

        public void doWork() throws Exception {
            Sample.this.printValues("Parts", Sample.this.views.getPartSet().iterator());
            Sample.this.printValues("Suppliers", Sample.this.views.getSupplierSet().iterator());
            Sample.this.printValues("Suppliers for City Paris", Sample.this.views.getSupplierByCityMap().duplicates((Object)"Paris").iterator());
            Sample.this.printValues("Shipments", Sample.this.views.getShipmentSet().iterator());
            Sample.this.printValues("Shipments for Part P1", Sample.this.views.getShipmentByPartMap().duplicates((Object)new PartKey("P1")).iterator());
            Sample.this.printValues("Shipments for Supplier S1", Sample.this.views.getShipmentBySupplierMap().duplicates((Object)new SupplierKey("S1")).iterator());
        }
    }

    private class PopulateDatabase
    implements TransactionWorker {
        private PopulateDatabase() {
        }

        public void doWork() throws Exception {
            Sample.this.addSuppliers();
            Sample.this.addParts();
            Sample.this.addShipments();
        }
    }
}

