/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.sentity;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialBinding;
import com.sleepycat.bdb.bind.tuple.TupleBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.collection.StoredSortedMap;
import com.sleepycat.bdb.collection.StoredSortedValueSet;
import com.sleepycat.examples.bdb.shipment.sentity.Part;
import com.sleepycat.examples.bdb.shipment.sentity.PartKey;
import com.sleepycat.examples.bdb.shipment.sentity.SampleDatabase;
import com.sleepycat.examples.bdb.shipment.sentity.Shipment;
import com.sleepycat.examples.bdb.shipment.sentity.ShipmentKey;
import com.sleepycat.examples.bdb.shipment.sentity.Supplier;
import com.sleepycat.examples.bdb.shipment.sentity.SupplierKey;
import java.io.IOException;

public class SampleViews {
    private StoredSortedMap partMap;
    private StoredSortedMap supplierMap;
    private StoredSortedMap shipmentMap;
    private StoredSortedMap shipmentByPartMap;
    private StoredSortedMap shipmentBySupplierMap;
    private StoredSortedMap supplierByCityMap;
    static /* synthetic */ Class class$java$lang$String;

    public SampleViews(SampleDatabase db) {
        PartKeyBinding partKeyBinding = new PartKeyBinding(db.getPartKeyFormat());
        PartBinding partValueBinding = new PartBinding(db.getPartKeyFormat(), db.getPartValueFormat());
        SupplierKeyBinding supplierKeyBinding = new SupplierKeyBinding(db.getSupplierKeyFormat());
        SupplierBinding supplierValueBinding = new SupplierBinding(db.getSupplierKeyFormat(), db.getSupplierValueFormat());
        ShipmentKeyBinding shipmentKeyBinding = new ShipmentKeyBinding(db.getShipmentKeyFormat());
        ShipmentBinding shipmentValueBinding = new ShipmentBinding(db.getShipmentKeyFormat(), db.getShipmentValueFormat());
        TupleBinding cityKeyBinding = TupleBinding.getPrimitiveBinding((Class)(class$java$lang$String == null ? (class$java$lang$String = SampleViews.class$("java.lang.String")) : class$java$lang$String), (TupleFormat)db.getCityKeyFormat());
        this.partMap = new StoredSortedMap(db.getPartStore(), (DataBinding)partKeyBinding, (EntityBinding)partValueBinding, true);
        this.supplierMap = new StoredSortedMap(db.getSupplierStore(), (DataBinding)supplierKeyBinding, (EntityBinding)supplierValueBinding, true);
        this.shipmentMap = new StoredSortedMap(db.getShipmentStore(), (DataBinding)shipmentKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentByPartMap = new StoredSortedMap((DataIndex)db.getShipmentByPartIndex(), (DataBinding)partKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentBySupplierMap = new StoredSortedMap((DataIndex)db.getShipmentBySupplierIndex(), (DataBinding)supplierKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.supplierByCityMap = new StoredSortedMap(db.getSupplierByCityIndex(), (DataBinding)cityKeyBinding, (EntityBinding)supplierValueBinding, true);
    }

    public StoredSortedMap getPartMap() {
        return this.partMap;
    }

    public StoredSortedMap getSupplierMap() {
        return this.supplierMap;
    }

    public StoredSortedMap getShipmentMap() {
        return this.shipmentMap;
    }

    public StoredSortedValueSet getPartSet() {
        return (StoredSortedValueSet)this.partMap.values();
    }

    public StoredSortedValueSet getSupplierSet() {
        return (StoredSortedValueSet)this.supplierMap.values();
    }

    public StoredSortedValueSet getShipmentSet() {
        return (StoredSortedValueSet)this.shipmentMap.values();
    }

    public StoredSortedMap getShipmentByPartMap() {
        return this.shipmentByPartMap;
    }

    public StoredSortedMap getShipmentBySupplierMap() {
        return this.shipmentBySupplierMap;
    }

    public final StoredSortedMap getSupplierByCityMap() {
        return this.supplierByCityMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShipmentBinding
    extends TupleSerialBinding {
        private ShipmentBinding(TupleFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(TupleInput keyInput, Object valueInput) throws IOException {
            String partNumber = keyInput.readString();
            String supplierNumber = keyInput.readString();
            Shipment shipment = (Shipment)valueInput;
            shipment.setKey(partNumber, supplierNumber);
            return shipment;
        }

        public void objectToKey(Object object, TupleOutput output) throws IOException {
            Shipment shipment = (Shipment)object;
            output.writeString(shipment.getPartNumber());
            output.writeString(shipment.getSupplierNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            return object;
        }
    }

    private static class ShipmentKeyBinding
    extends TupleBinding {
        private ShipmentKeyBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            String partNumber = input.readString();
            String supplierNumber = input.readString();
            return new ShipmentKey(partNumber, supplierNumber);
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            ShipmentKey key = (ShipmentKey)object;
            output.writeString(key.getPartNumber());
            output.writeString(key.getSupplierNumber());
        }
    }

    private static class SupplierBinding
    extends TupleSerialBinding {
        private SupplierBinding(TupleFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(TupleInput keyInput, Object valueInput) throws IOException {
            String number = keyInput.readString();
            Supplier supplier = (Supplier)valueInput;
            supplier.setKey(number);
            return supplier;
        }

        public void objectToKey(Object object, TupleOutput output) throws IOException {
            Supplier supplier = (Supplier)object;
            output.writeString(supplier.getNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            return object;
        }
    }

    private static class SupplierKeyBinding
    extends TupleBinding {
        private SupplierKeyBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            String number = input.readString();
            return new SupplierKey(number);
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            SupplierKey key = (SupplierKey)object;
            output.writeString(key.getNumber());
        }
    }

    private static class PartBinding
    extends TupleSerialBinding {
        private PartBinding(TupleFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(TupleInput keyInput, Object valueInput) throws IOException {
            String number = keyInput.readString();
            Part part = (Part)valueInput;
            part.setKey(number);
            return part;
        }

        public void objectToKey(Object object, TupleOutput output) throws IOException {
            Part part = (Part)object;
            output.writeString(part.getNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            return object;
        }
    }

    private static class PartKeyBinding
    extends TupleBinding {
        private PartKeyBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            String number = input.readString();
            return new PartKey(number);
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            PartKey key = (PartKey)object;
            output.writeString(key.getNumber());
        }
    }
}

