/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.marshal;

import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledEntity;
import java.io.IOException;
import java.io.Serializable;

public class Supplier
implements Serializable,
MarshalledEntity {
    static final String CITY_KEY = "city";
    private transient String number;
    private String name;
    private int status;
    private String city;

    public Supplier(String number, String name, int status, String city) {
        this.number = number;
        this.name = name;
        this.status = status;
        this.city = city;
    }

    void setKey(String number) {
        this.number = number;
    }

    public final String getNumber() {
        return this.number;
    }

    public final String getName() {
        return this.name;
    }

    public final int getStatus() {
        return this.status;
    }

    public final String getCity() {
        return this.city;
    }

    public String toString() {
        return "[Supplier: number=" + this.number + " name=" + this.name + " status=" + this.status + " city=" + this.city + ']';
    }

    Supplier() {
    }

    public void unmarshalPrimaryKey(TupleInput keyInput) throws IOException {
        this.number = keyInput.readString();
    }

    public void marshalPrimaryKey(TupleOutput keyOutput) throws IOException {
        keyOutput.writeString(this.number);
    }

    public void marshalIndexKey(String keyName, TupleOutput keyOutput) throws IOException {
        if (!keyName.equals(CITY_KEY)) {
            throw new UnsupportedOperationException(keyName);
        }
        keyOutput.writeString(this.city);
    }

    public void clearIndexKey(String keyName) throws IOException {
        if (!keyName.equals(CITY_KEY)) {
            throw new UnsupportedOperationException(keyName);
        }
        this.city = null;
    }
}

