/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.marshal;

import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledKey;
import java.io.IOException;

public class ShipmentKey
implements MarshalledKey {
    private String partNumber;
    private String supplierNumber;

    public ShipmentKey(String partNumber, String supplierNumber) {
        this.partNumber = partNumber;
        this.supplierNumber = supplierNumber;
    }

    public final String getPartNumber() {
        return this.partNumber;
    }

    public final String getSupplierNumber() {
        return this.supplierNumber;
    }

    public String toString() {
        return "[ShipmentKey: supplier=" + this.supplierNumber + " part=" + this.partNumber + ']';
    }

    ShipmentKey() {
    }

    public void unmarshalKey(TupleInput keyInput) throws IOException {
        this.partNumber = keyInput.readString();
        this.supplierNumber = keyInput.readString();
    }

    public void marshalKey(TupleOutput keyOutput) throws IOException {
        keyOutput.writeString(this.partNumber);
        keyOutput.writeString(this.supplierNumber);
    }
}

