/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.marshal;

import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledEntity;
import java.io.IOException;
import java.io.Serializable;

public class Shipment
implements Serializable,
MarshalledEntity {
    static final String PART_KEY = "part";
    static final String SUPPLIER_KEY = "supplier";
    private transient String partNumber;
    private transient String supplierNumber;
    private int quantity;

    public Shipment(String partNumber, String supplierNumber, int quantity) {
        this.partNumber = partNumber;
        this.supplierNumber = supplierNumber;
        this.quantity = quantity;
    }

    void setKey(String partNumber, String supplierNumber) {
        this.partNumber = partNumber;
        this.supplierNumber = supplierNumber;
    }

    public final String getPartNumber() {
        return this.partNumber;
    }

    public final String getSupplierNumber() {
        return this.supplierNumber;
    }

    public final int getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "[Shipment: part=" + this.partNumber + " supplier=" + this.supplierNumber + " quantity=" + this.quantity + ']';
    }

    Shipment() {
    }

    public void unmarshalPrimaryKey(TupleInput keyInput) throws IOException {
        this.partNumber = keyInput.readString();
        this.supplierNumber = keyInput.readString();
    }

    public void marshalPrimaryKey(TupleOutput keyOutput) throws IOException {
        keyOutput.writeString(this.partNumber);
        keyOutput.writeString(this.supplierNumber);
    }

    public void marshalIndexKey(String keyName, TupleOutput keyOutput) throws IOException {
        if (keyName.equals(PART_KEY)) {
            keyOutput.writeString(this.partNumber);
        } else if (keyName.equals(SUPPLIER_KEY)) {
            keyOutput.writeString(this.supplierNumber);
        } else {
            throw new UnsupportedOperationException(keyName);
        }
    }

    public void clearIndexKey(String keyName) throws IOException {
        if (keyName.equals(PART_KEY)) {
            this.partNumber = null;
        } else if (keyName.equals(SUPPLIER_KEY)) {
            this.supplierNumber = null;
        } else {
            throw new UnsupportedOperationException(keyName);
        }
    }
}

