/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.marshal;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialBinding;
import com.sleepycat.bdb.bind.tuple.TupleBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.collection.StoredSortedMap;
import com.sleepycat.bdb.collection.StoredSortedValueSet;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledEntity;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledKey;
import com.sleepycat.examples.bdb.shipment.marshal.SampleDatabase;
import java.io.IOException;

public class SampleViews {
    private StoredSortedMap partMap;
    private StoredSortedMap supplierMap;
    private StoredSortedMap shipmentMap;
    private StoredSortedMap shipmentByPartMap;
    private StoredSortedMap shipmentBySupplierMap;
    private StoredSortedMap supplierByCityMap;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$PartKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Part;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$SupplierKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Supplier;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$ShipmentKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Shipment;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledEntity;

    public SampleViews(SampleDatabase db) {
        MarshalledKeyBinding partKeyBinding = new MarshalledKeyBinding(db.getPartKeyFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$PartKey == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$PartKey = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.PartKey")) : class$com$sleepycat$examples$bdb$shipment$marshal$PartKey);
        MarshalledEntityBinding partValueBinding = new MarshalledEntityBinding(db.getPartKeyFormat(), db.getPartValueFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$Part == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Part = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.Part")) : class$com$sleepycat$examples$bdb$shipment$marshal$Part);
        MarshalledKeyBinding supplierKeyBinding = new MarshalledKeyBinding(db.getSupplierKeyFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$SupplierKey == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$SupplierKey = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.SupplierKey")) : class$com$sleepycat$examples$bdb$shipment$marshal$SupplierKey);
        MarshalledEntityBinding supplierValueBinding = new MarshalledEntityBinding(db.getSupplierKeyFormat(), db.getSupplierValueFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$Supplier == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Supplier = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.Supplier")) : class$com$sleepycat$examples$bdb$shipment$marshal$Supplier);
        MarshalledKeyBinding shipmentKeyBinding = new MarshalledKeyBinding(db.getShipmentKeyFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$ShipmentKey == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$ShipmentKey = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.ShipmentKey")) : class$com$sleepycat$examples$bdb$shipment$marshal$ShipmentKey);
        MarshalledEntityBinding shipmentValueBinding = new MarshalledEntityBinding(db.getShipmentKeyFormat(), db.getShipmentValueFormat(), class$com$sleepycat$examples$bdb$shipment$marshal$Shipment == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Shipment = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.Shipment")) : class$com$sleepycat$examples$bdb$shipment$marshal$Shipment);
        TupleBinding cityKeyBinding = TupleBinding.getPrimitiveBinding((Class)(class$java$lang$String == null ? (class$java$lang$String = SampleViews.class$("java.lang.String")) : class$java$lang$String), (TupleFormat)db.getCityKeyFormat());
        this.partMap = new StoredSortedMap(db.getPartStore(), (DataBinding)partKeyBinding, (EntityBinding)partValueBinding, true);
        this.supplierMap = new StoredSortedMap(db.getSupplierStore(), (DataBinding)supplierKeyBinding, (EntityBinding)supplierValueBinding, true);
        this.shipmentMap = new StoredSortedMap(db.getShipmentStore(), (DataBinding)shipmentKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentByPartMap = new StoredSortedMap((DataIndex)db.getShipmentByPartIndex(), (DataBinding)partKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentBySupplierMap = new StoredSortedMap((DataIndex)db.getShipmentBySupplierIndex(), (DataBinding)supplierKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.supplierByCityMap = new StoredSortedMap(db.getSupplierByCityIndex(), (DataBinding)cityKeyBinding, (EntityBinding)supplierValueBinding, true);
    }

    public StoredSortedMap getPartMap() {
        return this.partMap;
    }

    public StoredSortedMap getSupplierMap() {
        return this.supplierMap;
    }

    public StoredSortedMap getShipmentMap() {
        return this.shipmentMap;
    }

    public StoredSortedValueSet getPartSet() {
        return (StoredSortedValueSet)this.partMap.values();
    }

    public StoredSortedValueSet getSupplierSet() {
        return (StoredSortedValueSet)this.supplierMap.values();
    }

    public StoredSortedValueSet getShipmentSet() {
        return (StoredSortedValueSet)this.shipmentMap.values();
    }

    public StoredSortedMap getShipmentByPartMap() {
        return this.shipmentByPartMap;
    }

    public StoredSortedMap getShipmentBySupplierMap() {
        return this.shipmentBySupplierMap;
    }

    public final StoredSortedMap getSupplierByCityMap() {
        return this.supplierByCityMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MarshalledEntityBinding
    extends TupleSerialBinding {
        private Class entityClass;

        private MarshalledEntityBinding(TupleFormat keyFormat, SerialFormat valueFormat, Class entityClass) {
            super(keyFormat, valueFormat);
            if (!(class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledEntity == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledEntity = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.MarshalledEntity")) : class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledEntity).isAssignableFrom(entityClass)) {
                throw new IllegalArgumentException(entityClass.toString() + " does not implement MarshalledEntity");
            }
            this.entityClass = entityClass;
        }

        public Object dataToObject(TupleInput tupleInput, Object javaInput) throws IOException {
            MarshalledEntity entity = (MarshalledEntity)javaInput;
            entity.unmarshalPrimaryKey(tupleInput);
            return entity;
        }

        public void objectToKey(Object object, TupleOutput output) throws IOException {
            MarshalledEntity entity = (MarshalledEntity)object;
            entity.marshalPrimaryKey(output);
        }

        public Object objectToValue(Object object) throws IOException {
            return object;
        }
    }

    private static class MarshalledKeyBinding
    extends TupleBinding {
        private Class keyClass;

        private MarshalledKeyBinding(TupleFormat format, Class keyClass) {
            super(format);
            if (!(class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledKey == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledKey = SampleViews.class$("com.sleepycat.examples.bdb.shipment.marshal.MarshalledKey")) : class$com$sleepycat$examples$bdb$shipment$marshal$MarshalledKey).isAssignableFrom(keyClass)) {
                throw new IllegalArgumentException(keyClass.toString() + " does not implement MarshalledKey");
            }
            this.keyClass = keyClass;
        }

        public Object dataToObject(TupleInput input) throws IOException {
            try {
                MarshalledKey key = (MarshalledKey)this.keyClass.newInstance();
                key.unmarshalKey(input);
                return key;
            }
            catch (IllegalAccessException e) {
                throw new IOExceptionWrapper((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new IOExceptionWrapper((Throwable)e);
            }
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            MarshalledKey key = (MarshalledKey)object;
            key.marshalKey(output);
        }
    }
}

