/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.marshal;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.StoredClassCatalog;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialKeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.examples.bdb.shipment.marshal.MarshalledEntity;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SampleDatabase {
    private static final String CLASS_CATALOG = "java_class_catalog";
    private static final String SUPPLIER_STORE = "supplier_store";
    private static final String PART_STORE = "part_store";
    private static final String SHIPMENT_STORE = "shipment_store";
    private static final String SHIPMENT_PART_INDEX = "shipment_part_index";
    private static final String SHIPMENT_SUPPLIER_INDEX = "shipment_supplier_index";
    private static final String SUPPLIER_CITY_INDEX = "supplier_city_index";
    private DbEnv env;
    private DataStore supplierStore;
    private DataStore partStore;
    private DataStore shipmentStore;
    private DataIndex supplierByCityIndex;
    private ForeignKeyIndex shipmentByPartIndex;
    private ForeignKeyIndex shipmentBySupplierIndex;
    private StoredClassCatalog javaCatalog;
    private TupleFormat partKeyFormat;
    private SerialFormat partValueFormat;
    private TupleFormat supplierKeyFormat;
    private SerialFormat supplierValueFormat;
    private TupleFormat shipmentKeyFormat;
    private SerialFormat shipmentValueFormat;
    private TupleFormat cityKeyFormat;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Part;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Supplier;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$marshal$Shipment;

    public SampleDatabase(String homeDirectory, boolean runRecovery) throws DbException, FileNotFoundException {
        int envFlags = Db.DB_INIT_TXN | Db.DB_INIT_LOCK | Db.DB_INIT_MPOOL | Db.DB_CREATE;
        if (runRecovery) {
            envFlags |= Db.DB_RECOVER;
        }
        this.env = new DbEnv(0);
        System.out.println("Opening environment in: " + homeDirectory);
        this.env.open(homeDirectory, envFlags, 0);
        int flags = Db.DB_CREATE | Db.DB_AUTO_COMMIT;
        this.javaCatalog = new StoredClassCatalog(this.env, CLASS_CATALOG, null, flags);
        this.partKeyFormat = new TupleFormat();
        this.partValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$marshal$Part == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Part = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.marshal.Part")) : class$com$sleepycat$examples$bdb$shipment$marshal$Part);
        this.supplierKeyFormat = new TupleFormat();
        this.supplierValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$marshal$Supplier == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Supplier = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.marshal.Supplier")) : class$com$sleepycat$examples$bdb$shipment$marshal$Supplier);
        this.shipmentKeyFormat = new TupleFormat();
        this.shipmentValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$marshal$Shipment == null ? (class$com$sleepycat$examples$bdb$shipment$marshal$Shipment = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.marshal.Shipment")) : class$com$sleepycat$examples$bdb$shipment$marshal$Shipment);
        this.cityKeyFormat = new TupleFormat();
        Db partDb = new Db(this.env, 0);
        partDb.open(null, PART_STORE, null, 1, flags, 0);
        this.partStore = new DataStore(partDb, (DataFormat)this.partKeyFormat, (DataFormat)this.partValueFormat, null);
        Db supplierDb = new Db(this.env, 0);
        supplierDb.open(null, SUPPLIER_STORE, null, 1, flags, 0);
        this.supplierStore = new DataStore(supplierDb, (DataFormat)this.supplierKeyFormat, (DataFormat)this.supplierValueFormat, null);
        Db shipmentDb = new Db(this.env, 0);
        shipmentDb.open(null, SHIPMENT_STORE, null, 1, flags, 0);
        this.shipmentStore = new DataStore(shipmentDb, (DataFormat)this.shipmentKeyFormat, (DataFormat)this.shipmentValueFormat, null);
        MarshalledKeyExtractor cityExtractor = new MarshalledKeyExtractor(this.supplierKeyFormat, this.supplierValueFormat, this.cityKeyFormat, "city");
        MarshalledKeyExtractor partExtractor = new MarshalledKeyExtractor(this.shipmentKeyFormat, this.shipmentValueFormat, this.partKeyFormat, "part");
        MarshalledKeyExtractor supplierExtractor = new MarshalledKeyExtractor(this.shipmentKeyFormat, this.shipmentValueFormat, this.supplierKeyFormat, "supplier");
        Db cityIndexDb = new Db(this.env, 0);
        cityIndexDb.setFlags(Db.DB_DUPSORT);
        cityIndexDb.open(null, SUPPLIER_CITY_INDEX, null, 1, flags, 0);
        this.supplierByCityIndex = new DataIndex(this.supplierStore, cityIndexDb, (DataFormat)this.cityKeyFormat, (KeyExtractor)cityExtractor);
        Db partIndexDb = new Db(this.env, 0);
        partIndexDb.setFlags(Db.DB_DUPSORT);
        partIndexDb.open(null, SHIPMENT_PART_INDEX, null, 1, flags, 0);
        this.shipmentByPartIndex = new ForeignKeyIndex(this.shipmentStore, partIndexDb, (KeyExtractor)partExtractor, this.partStore, 1);
        Db supplierIndexDb = new Db(this.env, 0);
        supplierIndexDb.setFlags(Db.DB_DUPSORT);
        supplierIndexDb.open(null, SHIPMENT_SUPPLIER_INDEX, null, 1, flags, 0);
        this.shipmentBySupplierIndex = new ForeignKeyIndex(this.shipmentStore, supplierIndexDb, (KeyExtractor)supplierExtractor, this.supplierStore, 1);
    }

    public final DbEnv getEnvironment() {
        return this.env;
    }

    public final TupleFormat getPartKeyFormat() {
        return this.partKeyFormat;
    }

    public final SerialFormat getPartValueFormat() {
        return this.partValueFormat;
    }

    public final TupleFormat getSupplierKeyFormat() {
        return this.supplierKeyFormat;
    }

    public final SerialFormat getSupplierValueFormat() {
        return this.supplierValueFormat;
    }

    public final TupleFormat getShipmentKeyFormat() {
        return this.shipmentKeyFormat;
    }

    public final SerialFormat getShipmentValueFormat() {
        return this.shipmentValueFormat;
    }

    public final TupleFormat getCityKeyFormat() {
        return this.cityKeyFormat;
    }

    public final DataStore getPartStore() {
        return this.partStore;
    }

    public final DataStore getSupplierStore() {
        return this.supplierStore;
    }

    public final DataStore getShipmentStore() {
        return this.shipmentStore;
    }

    public final ForeignKeyIndex getShipmentByPartIndex() {
        return this.shipmentByPartIndex;
    }

    public final ForeignKeyIndex getShipmentBySupplierIndex() {
        return this.shipmentBySupplierIndex;
    }

    public final DataIndex getSupplierByCityIndex() {
        return this.supplierByCityIndex;
    }

    public void close() throws DbException, IOException {
        this.partStore.close();
        this.supplierStore.close();
        this.shipmentStore.close();
        this.javaCatalog.close();
        this.env.close(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MarshalledKeyExtractor
    extends TupleSerialKeyExtractor {
        private String keyName;

        private MarshalledKeyExtractor(TupleFormat primaryKeyFormat, SerialFormat valueFormat, TupleFormat indexKeyFormat, String keyName) {
            super(primaryKeyFormat, valueFormat, indexKeyFormat);
            this.keyName = keyName;
        }

        public void extractIndexKey(TupleInput primaryKeyInput, Object valueInput, TupleOutput indexKeyOutput) throws IOException {
            MarshalledEntity entity = (MarshalledEntity)valueInput;
            entity.unmarshalPrimaryKey(primaryKeyInput);
            entity.marshalIndexKey(this.keyName, indexKeyOutput);
        }

        public void clearIndexKey(Object valueInputOutput) throws IOException {
            MarshalledEntity entity = (MarshalledEntity)valueInputOutput;
            entity.clearIndexKey(this.keyName);
        }
    }
}

