/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.factory;

import com.sleepycat.bdb.bind.tuple.MarshalledTupleData;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public class ShipmentKey
implements MarshalledTupleData {
    private String partNumber;
    private String supplierNumber;

    public ShipmentKey(String partNumber, String supplierNumber) {
        this.partNumber = partNumber;
        this.supplierNumber = supplierNumber;
    }

    public final String getPartNumber() {
        return this.partNumber;
    }

    public final String getSupplierNumber() {
        return this.supplierNumber;
    }

    public String toString() {
        return "[ShipmentKey: supplier=" + this.supplierNumber + " part=" + this.partNumber + ']';
    }

    public ShipmentKey() {
    }

    public void marshalData(TupleOutput keyOutput) throws IOException {
        keyOutput.writeString(this.partNumber);
        keyOutput.writeString(this.supplierNumber);
    }

    public void unmarshalData(TupleInput keyInput) throws IOException {
        this.partNumber = keyInput.readString();
        this.supplierNumber = keyInput.readString();
    }
}

