/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.factory;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.StoredClassCatalog;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.factory.TupleSerialDbFactory;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;

public class SampleDatabase {
    private static final String CLASS_CATALOG = "java_class_catalog";
    private static final String SUPPLIER_STORE = "supplier_store";
    private static final String PART_STORE = "part_store";
    private static final String SHIPMENT_STORE = "shipment_store";
    private static final String SHIPMENT_PART_INDEX = "shipment_part_index";
    private static final String SHIPMENT_SUPPLIER_INDEX = "shipment_supplier_index";
    private static final String SUPPLIER_CITY_INDEX = "supplier_city_index";
    private DbEnv env;
    private DataStore supplierStore;
    private DataStore partStore;
    private DataStore shipmentStore;
    private DataIndex supplierByCityIndex;
    private ForeignKeyIndex shipmentByPartIndex;
    private ForeignKeyIndex shipmentBySupplierIndex;
    private StoredClassCatalog javaCatalog;
    private TupleSerialDbFactory factory;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$factory$Part;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$factory$Supplier;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$factory$Shipment;

    public SampleDatabase(String homeDirectory, boolean runRecovery) throws Exception {
        int envFlags = Db.DB_INIT_TXN | Db.DB_INIT_LOCK | Db.DB_INIT_MPOOL | Db.DB_CREATE;
        if (runRecovery) {
            envFlags |= Db.DB_RECOVER;
        }
        this.env = new DbEnv(0);
        System.out.println("Opening environment in: " + homeDirectory);
        this.env.open(homeDirectory, envFlags, 0);
        int flags = Db.DB_CREATE | Db.DB_AUTO_COMMIT;
        this.javaCatalog = new StoredClassCatalog(this.env, CLASS_CATALOG, null, flags);
        this.factory = new TupleSerialDbFactory((ClassCatalog)this.javaCatalog);
        Db partDb = new Db(this.env, 0);
        partDb.open(null, PART_STORE, null, 1, flags, 0);
        this.partStore = this.factory.newDataStore(partDb, class$com$sleepycat$examples$bdb$shipment$factory$Part == null ? (class$com$sleepycat$examples$bdb$shipment$factory$Part = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.factory.Part")) : class$com$sleepycat$examples$bdb$shipment$factory$Part, null);
        Db supplierDb = new Db(this.env, 0);
        supplierDb.open(null, SUPPLIER_STORE, null, 1, flags, 0);
        this.supplierStore = this.factory.newDataStore(supplierDb, class$com$sleepycat$examples$bdb$shipment$factory$Supplier == null ? (class$com$sleepycat$examples$bdb$shipment$factory$Supplier = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.factory.Supplier")) : class$com$sleepycat$examples$bdb$shipment$factory$Supplier, null);
        Db shipmentDb = new Db(this.env, 0);
        shipmentDb.open(null, SHIPMENT_STORE, null, 1, flags, 0);
        this.shipmentStore = this.factory.newDataStore(shipmentDb, class$com$sleepycat$examples$bdb$shipment$factory$Shipment == null ? (class$com$sleepycat$examples$bdb$shipment$factory$Shipment = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.factory.Shipment")) : class$com$sleepycat$examples$bdb$shipment$factory$Shipment, null);
        Db cityIndexDb = new Db(this.env, 0);
        cityIndexDb.setFlags(Db.DB_DUPSORT);
        cityIndexDb.open(null, SUPPLIER_CITY_INDEX, null, 1, flags, 0);
        this.supplierByCityIndex = this.factory.newDataIndex(this.supplierStore, cityIndexDb, "city", false, true);
        Db partIndexDb = new Db(this.env, 0);
        partIndexDb.setFlags(Db.DB_DUPSORT);
        partIndexDb.open(null, SHIPMENT_PART_INDEX, null, 1, flags, 0);
        this.shipmentByPartIndex = this.factory.newForeignKeyIndex(this.shipmentStore, partIndexDb, "part", false, true, this.partStore, 1);
        Db supplierIndexDb = new Db(this.env, 0);
        supplierIndexDb.setFlags(Db.DB_DUPSORT);
        supplierIndexDb.open(null, SHIPMENT_SUPPLIER_INDEX, null, 1, flags, 0);
        this.shipmentBySupplierIndex = this.factory.newForeignKeyIndex(this.shipmentStore, supplierIndexDb, "supplier", false, true, this.supplierStore, 1);
    }

    public final TupleSerialDbFactory getFactory() {
        return this.factory;
    }

    public final DbEnv getEnvironment() {
        return this.env;
    }

    public final DataStore getPartStore() {
        return this.partStore;
    }

    public final DataStore getSupplierStore() {
        return this.supplierStore;
    }

    public final DataStore getShipmentStore() {
        return this.shipmentStore;
    }

    public final ForeignKeyIndex getShipmentByPartIndex() {
        return this.shipmentByPartIndex;
    }

    public final ForeignKeyIndex getShipmentBySupplierIndex() {
        return this.shipmentBySupplierIndex;
    }

    public final DataIndex getSupplierByCityIndex() {
        return this.supplierByCityIndex;
    }

    public void close() throws Exception {
        this.partStore.close();
        this.supplierStore.close();
        this.shipmentStore.close();
        this.javaCatalog.close();
        this.env.close(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

