/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.entity;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.SerialBinding;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.SerialSerialBinding;
import com.sleepycat.bdb.collection.StoredMap;
import com.sleepycat.bdb.collection.StoredValueSet;
import com.sleepycat.examples.bdb.shipment.entity.Part;
import com.sleepycat.examples.bdb.shipment.entity.PartKey;
import com.sleepycat.examples.bdb.shipment.entity.PartValue;
import com.sleepycat.examples.bdb.shipment.entity.SampleDatabase;
import com.sleepycat.examples.bdb.shipment.entity.Shipment;
import com.sleepycat.examples.bdb.shipment.entity.ShipmentKey;
import com.sleepycat.examples.bdb.shipment.entity.ShipmentValue;
import com.sleepycat.examples.bdb.shipment.entity.Supplier;
import com.sleepycat.examples.bdb.shipment.entity.SupplierKey;
import com.sleepycat.examples.bdb.shipment.entity.SupplierValue;
import java.io.IOException;

public class SampleViews {
    private StoredMap partMap;
    private StoredMap supplierMap;
    private StoredMap shipmentMap;
    private StoredMap shipmentByPartMap;
    private StoredMap shipmentBySupplierMap;
    private StoredMap supplierByCityMap;

    public SampleViews(SampleDatabase db) {
        SerialBinding partKeyBinding = new SerialBinding(db.getPartKeyFormat());
        PartBinding partValueBinding = new PartBinding(db.getPartKeyFormat(), db.getPartValueFormat());
        SerialBinding supplierKeyBinding = new SerialBinding(db.getSupplierKeyFormat());
        SupplierBinding supplierValueBinding = new SupplierBinding(db.getSupplierKeyFormat(), db.getSupplierValueFormat());
        SerialBinding shipmentKeyBinding = new SerialBinding(db.getShipmentKeyFormat());
        ShipmentBinding shipmentValueBinding = new ShipmentBinding(db.getShipmentKeyFormat(), db.getShipmentValueFormat());
        SerialBinding cityKeyBinding = new SerialBinding(db.getCityKeyFormat());
        this.partMap = new StoredMap(db.getPartStore(), (DataBinding)partKeyBinding, (EntityBinding)partValueBinding, true);
        this.supplierMap = new StoredMap(db.getSupplierStore(), (DataBinding)supplierKeyBinding, (EntityBinding)supplierValueBinding, true);
        this.shipmentMap = new StoredMap(db.getShipmentStore(), (DataBinding)shipmentKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentByPartMap = new StoredMap((DataIndex)db.getShipmentByPartIndex(), (DataBinding)partKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.shipmentBySupplierMap = new StoredMap((DataIndex)db.getShipmentBySupplierIndex(), (DataBinding)supplierKeyBinding, (EntityBinding)shipmentValueBinding, true);
        this.supplierByCityMap = new StoredMap(db.getSupplierByCityIndex(), (DataBinding)cityKeyBinding, (EntityBinding)supplierValueBinding, true);
    }

    public StoredMap getPartMap() {
        return this.partMap;
    }

    public StoredMap getSupplierMap() {
        return this.supplierMap;
    }

    public StoredMap getShipmentMap() {
        return this.shipmentMap;
    }

    public StoredValueSet getPartSet() {
        return (StoredValueSet)this.partMap.values();
    }

    public StoredValueSet getSupplierSet() {
        return (StoredValueSet)this.supplierMap.values();
    }

    public StoredValueSet getShipmentSet() {
        return (StoredValueSet)this.shipmentMap.values();
    }

    public StoredMap getShipmentByPartMap() {
        return this.shipmentByPartMap;
    }

    public StoredMap getShipmentBySupplierMap() {
        return this.shipmentBySupplierMap;
    }

    public final StoredMap getSupplierByCityMap() {
        return this.supplierByCityMap;
    }

    private static class ShipmentBinding
    extends SerialSerialBinding {
        private ShipmentBinding(SerialFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(Object keyInput, Object valueInput) throws IOException {
            ShipmentKey key = (ShipmentKey)keyInput;
            ShipmentValue value = (ShipmentValue)valueInput;
            return new Shipment(key.getPartNumber(), key.getSupplierNumber(), value.getQuantity());
        }

        public Object objectToKey(Object object) throws IOException {
            Shipment shipment = (Shipment)object;
            return new ShipmentKey(shipment.getPartNumber(), shipment.getSupplierNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            Shipment shipment = (Shipment)object;
            return new ShipmentValue(shipment.getQuantity());
        }
    }

    private static class SupplierBinding
    extends SerialSerialBinding {
        private SupplierBinding(SerialFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(Object keyInput, Object valueInput) throws IOException {
            SupplierKey key = (SupplierKey)keyInput;
            SupplierValue value = (SupplierValue)valueInput;
            return new Supplier(key.getNumber(), value.getName(), value.getStatus(), value.getCity());
        }

        public Object objectToKey(Object object) throws IOException {
            Supplier supplier = (Supplier)object;
            return new SupplierKey(supplier.getNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            Supplier supplier = (Supplier)object;
            return new SupplierValue(supplier.getName(), supplier.getStatus(), supplier.getCity());
        }
    }

    private static class PartBinding
    extends SerialSerialBinding {
        private PartBinding(SerialFormat keyFormat, SerialFormat valueFormat) {
            super(keyFormat, valueFormat);
        }

        public Object dataToObject(Object keyInput, Object valueInput) throws IOException {
            PartKey key = (PartKey)keyInput;
            PartValue value = (PartValue)valueInput;
            return new Part(key.getNumber(), value.getName(), value.getColor(), value.getWeight(), value.getCity());
        }

        public Object objectToKey(Object object) throws IOException {
            Part part = (Part)object;
            return new PartKey(part.getNumber());
        }

        public Object objectToValue(Object object) throws IOException {
            Part part = (Part)object;
            return new PartValue(part.getName(), part.getColor(), part.getWeight(), part.getCity());
        }
    }
}

