/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.entity;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.StoredClassCatalog;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.SerialSerialKeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.examples.bdb.shipment.entity.PartKey;
import com.sleepycat.examples.bdb.shipment.entity.ShipmentKey;
import com.sleepycat.examples.bdb.shipment.entity.SupplierKey;
import com.sleepycat.examples.bdb.shipment.entity.SupplierValue;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SampleDatabase {
    private static final String CLASS_CATALOG = "java_class_catalog";
    private static final String SUPPLIER_STORE = "supplier_store";
    private static final String PART_STORE = "part_store";
    private static final String SHIPMENT_STORE = "shipment_store";
    private static final String SHIPMENT_PART_INDEX = "shipment_part_index";
    private static final String SHIPMENT_SUPPLIER_INDEX = "shipment_supplier_index";
    private static final String SUPPLIER_CITY_INDEX = "supplier_city_index";
    private DbEnv env;
    private DataStore supplierStore;
    private DataStore partStore;
    private DataStore shipmentStore;
    private DataIndex supplierByCityIndex;
    private ForeignKeyIndex shipmentByPartIndex;
    private ForeignKeyIndex shipmentBySupplierIndex;
    private StoredClassCatalog javaCatalog;
    private SerialFormat partKeyFormat;
    private SerialFormat partValueFormat;
    private SerialFormat supplierKeyFormat;
    private SerialFormat supplierValueFormat;
    private SerialFormat shipmentKeyFormat;
    private SerialFormat shipmentValueFormat;
    private SerialFormat cityKeyFormat;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$PartKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$PartValue;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$SupplierKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$SupplierValue;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$ShipmentKey;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$entity$ShipmentValue;
    static /* synthetic */ Class class$java$lang$String;

    public SampleDatabase(String homeDirectory, boolean runRecovery) throws DbException, FileNotFoundException {
        int envFlags = Db.DB_INIT_TXN | Db.DB_INIT_LOCK | Db.DB_INIT_MPOOL | Db.DB_CREATE;
        if (runRecovery) {
            envFlags |= Db.DB_RECOVER;
        }
        this.env = new DbEnv(0);
        System.out.println("Opening environment in: " + homeDirectory);
        this.env.open(homeDirectory, envFlags, 0);
        int flags = Db.DB_CREATE | Db.DB_AUTO_COMMIT;
        this.javaCatalog = new StoredClassCatalog(this.env, CLASS_CATALOG, null, flags);
        this.partKeyFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$PartKey == null ? (class$com$sleepycat$examples$bdb$shipment$entity$PartKey = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.PartKey")) : class$com$sleepycat$examples$bdb$shipment$entity$PartKey);
        this.partValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$PartValue == null ? (class$com$sleepycat$examples$bdb$shipment$entity$PartValue = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.PartValue")) : class$com$sleepycat$examples$bdb$shipment$entity$PartValue);
        this.supplierKeyFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$SupplierKey == null ? (class$com$sleepycat$examples$bdb$shipment$entity$SupplierKey = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.SupplierKey")) : class$com$sleepycat$examples$bdb$shipment$entity$SupplierKey);
        this.supplierValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$SupplierValue == null ? (class$com$sleepycat$examples$bdb$shipment$entity$SupplierValue = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.SupplierValue")) : class$com$sleepycat$examples$bdb$shipment$entity$SupplierValue);
        this.shipmentKeyFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$ShipmentKey == null ? (class$com$sleepycat$examples$bdb$shipment$entity$ShipmentKey = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.ShipmentKey")) : class$com$sleepycat$examples$bdb$shipment$entity$ShipmentKey);
        this.shipmentValueFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$com$sleepycat$examples$bdb$shipment$entity$ShipmentValue == null ? (class$com$sleepycat$examples$bdb$shipment$entity$ShipmentValue = SampleDatabase.class$("com.sleepycat.examples.bdb.shipment.entity.ShipmentValue")) : class$com$sleepycat$examples$bdb$shipment$entity$ShipmentValue);
        this.cityKeyFormat = new SerialFormat((ClassCatalog)this.javaCatalog, class$java$lang$String == null ? (class$java$lang$String = SampleDatabase.class$("java.lang.String")) : class$java$lang$String);
        Db partDb = new Db(this.env, 0);
        partDb.open(null, PART_STORE, null, 1, flags, 0);
        this.partStore = new DataStore(partDb, (DataFormat)this.partKeyFormat, (DataFormat)this.partValueFormat, null);
        Db supplierDb = new Db(this.env, 0);
        supplierDb.open(null, SUPPLIER_STORE, null, 1, flags, 0);
        this.supplierStore = new DataStore(supplierDb, (DataFormat)this.supplierKeyFormat, (DataFormat)this.supplierValueFormat, null);
        Db shipmentDb = new Db(this.env, 0);
        shipmentDb.open(null, SHIPMENT_STORE, null, 1, flags, 0);
        this.shipmentStore = new DataStore(shipmentDb, (DataFormat)this.shipmentKeyFormat, (DataFormat)this.shipmentValueFormat, null);
        SupplierByCityExtractor cityExtractor = new SupplierByCityExtractor(this.supplierKeyFormat, this.supplierValueFormat, this.cityKeyFormat);
        ShipmentByPartExtractor partExtractor = new ShipmentByPartExtractor(this.shipmentKeyFormat, this.shipmentValueFormat, this.partKeyFormat);
        ShipmentBySupplierExtractor supplierExtractor = new ShipmentBySupplierExtractor(this.shipmentKeyFormat, this.shipmentValueFormat, this.supplierKeyFormat);
        Db cityIndexDb = new Db(this.env, 0);
        cityIndexDb.setFlags(Db.DB_DUPSORT);
        cityIndexDb.open(null, SUPPLIER_CITY_INDEX, null, 1, flags, 0);
        this.supplierByCityIndex = new DataIndex(this.supplierStore, cityIndexDb, (DataFormat)this.cityKeyFormat, (KeyExtractor)cityExtractor);
        Db partIndexDb = new Db(this.env, 0);
        partIndexDb.setFlags(Db.DB_DUPSORT);
        partIndexDb.open(null, SHIPMENT_PART_INDEX, null, 1, flags, 0);
        this.shipmentByPartIndex = new ForeignKeyIndex(this.shipmentStore, partIndexDb, (KeyExtractor)partExtractor, this.partStore, 1);
        Db supplierIndexDb = new Db(this.env, 0);
        supplierIndexDb.setFlags(Db.DB_DUPSORT);
        supplierIndexDb.open(null, SHIPMENT_SUPPLIER_INDEX, null, 1, flags, 0);
        this.shipmentBySupplierIndex = new ForeignKeyIndex(this.shipmentStore, supplierIndexDb, (KeyExtractor)supplierExtractor, this.supplierStore, 1);
    }

    public final DbEnv getEnvironment() {
        return this.env;
    }

    public final SerialFormat getPartKeyFormat() {
        return this.partKeyFormat;
    }

    public final SerialFormat getPartValueFormat() {
        return this.partValueFormat;
    }

    public final SerialFormat getSupplierKeyFormat() {
        return this.supplierKeyFormat;
    }

    public final SerialFormat getSupplierValueFormat() {
        return this.supplierValueFormat;
    }

    public final SerialFormat getShipmentKeyFormat() {
        return this.shipmentKeyFormat;
    }

    public final SerialFormat getShipmentValueFormat() {
        return this.shipmentValueFormat;
    }

    public final SerialFormat getCityKeyFormat() {
        return this.cityKeyFormat;
    }

    public final DataStore getPartStore() {
        return this.partStore;
    }

    public final DataStore getSupplierStore() {
        return this.supplierStore;
    }

    public final DataStore getShipmentStore() {
        return this.shipmentStore;
    }

    public final ForeignKeyIndex getShipmentByPartIndex() {
        return this.shipmentByPartIndex;
    }

    public final ForeignKeyIndex getShipmentBySupplierIndex() {
        return this.shipmentBySupplierIndex;
    }

    public final DataIndex getSupplierByCityIndex() {
        return this.supplierByCityIndex;
    }

    public void close() throws DbException, IOException {
        this.partStore.close();
        this.supplierStore.close();
        this.shipmentStore.close();
        this.javaCatalog.close();
        this.env.close(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShipmentBySupplierExtractor
    extends SerialSerialKeyExtractor {
        private ShipmentBySupplierExtractor(SerialFormat primaryKeyFormat, SerialFormat valueFormat, SerialFormat indexKeyFormat) {
            super(primaryKeyFormat, valueFormat, indexKeyFormat);
        }

        public Object extractIndexKey(Object primaryKeyInput, Object valueInput) throws IOException {
            ShipmentKey shipmentKey = (ShipmentKey)primaryKeyInput;
            return new SupplierKey(shipmentKey.getSupplierNumber());
        }

        public Object clearIndexKey(Object valueInputOutput) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class ShipmentByPartExtractor
    extends SerialSerialKeyExtractor {
        private ShipmentByPartExtractor(SerialFormat primaryKeyFormat, SerialFormat valueFormat, SerialFormat indexKeyFormat) {
            super(primaryKeyFormat, valueFormat, indexKeyFormat);
        }

        public Object extractIndexKey(Object primaryKeyInput, Object valueInput) throws IOException {
            ShipmentKey shipmentKey = (ShipmentKey)primaryKeyInput;
            return new PartKey(shipmentKey.getPartNumber());
        }

        public Object clearIndexKey(Object valueInputOutput) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SupplierByCityExtractor
    extends SerialSerialKeyExtractor {
        private SupplierByCityExtractor(SerialFormat primaryKeyFormat, SerialFormat valueFormat, SerialFormat indexKeyFormat) {
            super(primaryKeyFormat, valueFormat, indexKeyFormat);
        }

        public Object extractIndexKey(Object primaryKeyInput, Object valueInput) throws IOException {
            SupplierValue supplierValue = (SupplierValue)valueInput;
            return supplierValue.getCity();
        }

        public Object clearIndexKey(Object valueInputOutput) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

