/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.basic;

import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.serial.SerialBinding;
import com.sleepycat.bdb.collection.StoredEntrySet;
import com.sleepycat.bdb.collection.StoredMap;
import com.sleepycat.examples.bdb.shipment.basic.SampleDatabase;

public class SampleViews {
    private StoredMap partMap;
    private StoredMap supplierMap;
    private StoredMap shipmentMap;

    public SampleViews(SampleDatabase db) {
        SerialBinding partKeyBinding = new SerialBinding(db.getPartKeyFormat());
        SerialBinding partValueBinding = new SerialBinding(db.getPartValueFormat());
        SerialBinding supplierKeyBinding = new SerialBinding(db.getSupplierKeyFormat());
        SerialBinding supplierValueBinding = new SerialBinding(db.getSupplierValueFormat());
        SerialBinding shipmentKeyBinding = new SerialBinding(db.getShipmentKeyFormat());
        SerialBinding shipmentValueBinding = new SerialBinding(db.getShipmentValueFormat());
        this.partMap = new StoredMap(db.getPartStore(), (DataBinding)partKeyBinding, (DataBinding)partValueBinding, true);
        this.supplierMap = new StoredMap(db.getSupplierStore(), (DataBinding)supplierKeyBinding, (DataBinding)supplierValueBinding, true);
        this.shipmentMap = new StoredMap(db.getShipmentStore(), (DataBinding)shipmentKeyBinding, (DataBinding)shipmentValueBinding, true);
    }

    public final StoredMap getPartMap() {
        return this.partMap;
    }

    public final StoredMap getSupplierMap() {
        return this.supplierMap;
    }

    public final StoredMap getShipmentMap() {
        return this.shipmentMap;
    }

    public final StoredEntrySet getPartEntrySet() {
        return (StoredEntrySet)this.partMap.entrySet();
    }

    public final StoredEntrySet getSupplierEntrySet() {
        return (StoredEntrySet)this.supplierMap.entrySet();
    }

    public final StoredEntrySet getShipmentEntrySet() {
        return (StoredEntrySet)this.shipmentMap.entrySet();
    }
}

